var app = angular.module('casinoApp', [
  'ngRoute',
  'RouteData',
  'ngMessages',
  'ngDialog',
  'ngSweetAlert',
  'pascalprecht.translate',
  'ngCookies',
  'ngCurrencySymbol',
  'ui.bootstrap.pagination',
  'internationalPhoneNumber',
  'ngIdle'
]);

//ngIdle

app.config(['IdleProvider', function(IdleProvider) {
  IdleProvider.idle(1800);
  IdleProvider.timeout(5);
}]);

app.run(function(Idle){
  // start watching when the app runs. also starts the Keepalive service by default.
  Idle.watch();
});
app.config(['$routeProvider', 'RouteDataProvider', '$translateProvider', function ($routeProvider, RouteDataProvider, $translateProvider) {
  RouteDataProvider.applyConfig({bodyClass: 'bg-main'});
  RouteDataProvider.hookToRootScope(true);

  $translateProvider.useStaticFilesLoader({
    prefix: '/common/js/resources/locale-',
    suffix: '.json'
  });

  //default load when user already selected language from dropdown
  var jsCookieLang = document.cookie;
  var arrayLang = ["ko_KR"];

  var i;
  for (i = 0; i < arrayLang.length; i++) {
    if (jsCookieLang.search(arrayLang[i]) > 0) {
      var setLang = arrayLang[i];
    }
  }
/*
  var languageSelector = function (langKey) {
    var font = 'kr.css';
    var langName = " 한국어";
    var lang = langKey.substring(0, 2);
	alert('11');
    if (lang == "en") {
      font = "en.css";
      langName = " ENGLISH";
	  alert('22');
    } else if (lang == "ko") {
      font = "kr.css";
      langName = " 한국어";
	  alert('33');
    } else if (lang == "ja") {
      font = "jp.css";
      langName = " 日本語";
	  alert('44');
    } else if (lang == "zh") {
      font = "cn.css";
      langName = " 中文";
	  alert('55');
    } else if (lang == "id") {
      font = "id.css";
      langName = " INDONESIA";
	  alert('6');
    } else {
      font = "ko.css";
      langName = " 한국어";
    }
alert('2');
    $('#language-flag').html('<i class="icon-lang language-' + langKey.substring(0, 2) + '"></i><span>' + langName + '</span><span class="caret"></span>');

    var fileref = document.createElement("link");
    fileref.setAttribute("rel", "stylesheet");
    fileref.setAttribute("href", "/common/css/languages/" + font);


    if (typeof fileref != "undefined") {
      document.getElementsByTagName("head")[0].appendChild(fileref);
    }

    return font;
  };
*/
  if (setLang) {
    $translateProvider.preferredLanguage(setLang);

    if (setLang == "ko_KR") {
      $translateProvider.useLocalStorage(angular.lowercase(setLang.substring(3, 5)));
    } else {
      $translateProvider.useLocalStorage(setLang.substring(0, 2));
    }

    languageSelector(setLang);

  } else {
    //user default browser language
    var userLang = navigator.language || navigator.userLanguage; //for IE8 = navigator.userLanguage
    var u;
    for (u = 0; u < arrayLang.length; u++) {
      if (arrayLang[u].search(userLang.replace("-", "_")) == 0) {
        var browserLang = arrayLang[u].replace("-", "_");
      }
    }

    if (browserLang == undefined) {
      languageSelector(userLang);
      $translateProvider.preferredLanguage(userLang.substring(0, 2) + "_" + userLang.substring(3, 5).toUpperCase());
    } else {
      $translateProvider.preferredLanguage(browserLang);
      languageSelector(userLang);
    }
  }

  $translateProvider.useLocalStorage();
  $translateProvider.useSanitizeValueStrategy('escaped');

  $routeProvider
    .when('/', {RouteData: {bodyClass: 'bg-main'}, templateUrl: 'pages/main.php', controller: '', activetab: 'main'})
    .when('/mobile', {RouteData: {bodyClass: 'bg-mobile'}, templateUrl: 'pages/mobile.php', controller: '', activetab: 'mobile'})
    .when('/sports', {RouteData: {bodyClass: 'bg-sports'}, templateUrl: 'pages/sports.php', controller: '', activetab: 'sports'})
    .when('/casino', {RouteData: {bodyClass: 'bg-casino'}, templateUrl: 'pages/casino.php', controller: '', activetab: 'casino'})
    .when('/mini', {RouteData: {bodyClass: 'bg-mini'}, templateUrl: 'pages/mini.php', controller: '', activetab: 'mini'})
    .when('/evolution', {RouteData: {bodyClass: 'bg-evolution'}, templateUrl: 'pages/evolution.php', controller: '', activetab: 'evolution'})
    .when('/poker', {RouteData: {bodyClass: 'bg-poker'}, templateUrl: 'pages/poker.php', controller: '', activetab: 'poker'})
    .when('/slots', {RouteData: {bodyClass: 'bg-slots'}, templateUrl: 'pages/slots.php', controller: 'SlotController', activetab: 'slots'})
    .when('/game', {RouteData: {bodyClass: 'bg-game'}, templateUrl: 'pages/game.php', controller: '', activetab: 'game'})
    .when('/graph', {RouteData: {bodyClass: 'bg-main'}, templateUrl: 'pages/graph.php', controller: '', activetab: 'graph'})
    .when('/promotion', {RouteData: {bodyClass: 'bg-promotion'}, templateUrl: 'pages/promotion.php', controller: '', activetab: 'promotion'})
    .when('/view-sports', {RouteData: {bodyClass: 'bg-viewsport'}, templateUrl: 'pages/view-sports.php', controller: '', activetab: 'sports'})
    .when('/esports', {RouteData: {bodyClass: ''}, templateUrl: 'pages/esports.php', controller: '', activetab: 'esports'})
    .when('/user-guide', {RouteData: {bodyClass: 'bg-user-guide'}, templateUrl: 'pages/user-guide.php', controller: ''})
    .otherwise({
      redirectTo: '/',
      RouteData: {bodyClass: 'bg-main'},
      templateUrl: '../main/main.php',
      controller: ''
    });
}]);

app.config(['ngDialogProvider', function (ngDialogProvider) {
  ngDialogProvider.setDefaults({
    closeByEscape: false,
    showClose: true,
    ariaAuto: false,
    ariaRole: false,
    setOpenOnePerName: true
  });
}]);

app.service('loggedInStatus', function ($rootScope) {
  return {
    setLoggedInStatus: function () {
      $rootScope.loggedIn = true;
      $rootScope.loggedOut = false;
    },
    setLoggedOutStatus: function () {
      $rootScope.loggedIn = false;
      $rootScope.loggedOut = true;
    }
  };
});

app.config(function ($provide) {
  $provide.decorator('inputDirective', function ($delegate, $log) {
    $log.debug('Hijacking input directive');
    var directive = $delegate[0];
    angular.extend(directive.link, {
      post: function (scope, element, attr, ctrls) {
        element.on('compositionupdate', function (event) {
          element.triggerHandler('compositionend');
        })
      }
    });
    return $delegate;
  });
});

app.service('AmountService', function () {
  return {
    sumAmount: function (amount, amountSum) {
      //console.log(amountSum);
      if (amount == "NaN" || amount == "") {
        return parseFloat(amountSum);
      }
      amount = parseFloat(amount) + parseFloat(amountSum);
      return amount;
    },
    resetAmount: function () {
      return 0;
    }
  };
});

app.filter('htmlToPlaintext', function () {
  return function (text) {
    /*REMOVE HTML TAGS*/
    var contents = String(text).replace(/<[^>]+>/gm, '');
    /*REMOVE NBSP*/
    contents = String(contents).replace(/&nbsp;/g, " ");
    return text ? contents : '';
  };
});

app.filter('customCurrency', ["$filter", function ($filter) {
  return function (amount, currencySymbol) {
    //console.log(amount);
    var number = $filter('number');
    if (String(amount).charAt(0) === "-") {
      return number(amount).replace("-", "-" + currencySymbol);
    }
    if (amount == undefined) {
      return "Loading";
    } else {
      return number(amount) + currencySymbol;
    }
  };
}]);

app.filter('userDateTimeTimeZone', function ($filter) {
  return function (input, format, offset) {
    if (input == null) {
      return "";
    }
    var timeFromUTC = moment.utc(input);
    var tzName = jstz.determine().name();
    var _date = moment(timeFromUTC, tzName).format("YYYY-MM-DD HH:mm:ss Z");
    return _date.toString();
  }
});

app.filter('userDateTime', function ($filter) {
  return function (input, format, offset) {
    if (input == null) {
      return "";
    }
    var timeFromUTC = moment.utc(input);
    var tzName = jstz.determine().name();
    var _date = moment.tz(timeFromUTC, tzName).format("YYYY-MM-DD HH:mm");
    return _date.toString();
  }
});

app.filter('userDate', function ($filter) {
  return function (input, format, offset) {
    if (input == null) {
      return "";
    }
    var timeFromUTC = moment.utc(input);
    var tzName = jstz.determine().name();
    var _date = moment.tz(timeFromUTC, tzName).format("YYYY-MM-DD");
    return _date.toString();
  }
});

app.filter('nl2br', ['$sce', function ($sce) {
  return function (text) {
    return text ? $sce.trustAsHtml(text.replace(/\n/g, '<br/>')) : '';
  };
}]);

app.filter("trustUrl", ['$sce', function ($sce) {
  return function (recordingUrl) {
    return $sce.trustAsResourceUrl(recordingUrl);
  };
}]);

app.directive("addAmountList", function () {
  return {
    link: function (scope, element, attrs) {
      scope.data = scope[attrs["addAmountList"]];
    },
    restrict: "A",
    template: "<button type='button' class='btn btn-drkgray btn-option' ng-repeat='item in data' ng-click='addAmount(item.price)'>{{item.price | number}} {{item.currency}}</button>"
  }
});

//Matched Password Filter
app.directive('validPasswordC', function () {
  return {
    require: 'ngModel',
    link: function (scope, elm, attrs, ctrl) {
      var original;
      ctrl.$formatters.unshift(function (modelValue) {
        original = modelValue;
        return modelValue;
      });
      ctrl.$parsers.push(function (viewValue) {
        var noMatch = viewValue != scope.signUp.MemberPwd.$viewValue;
        ctrl.$setValidity('noMatch', !noMatch);
        return viewValue;
      });
    }
  }
});

//Matched New Password Filter
app.directive('validPasswordC2', function () {
  return {
    require: 'ngModel',
    link: function (scope, elm, attrs, ctrl) {
      var original;
      ctrl.$formatters.unshift(function (modelValue) {
        original = modelValue;
        return modelValue;
      });
      ctrl.$parsers.push(function (viewValue) {
        var noMatch = viewValue != scope.changePwdForm.newPassword.$viewValue;
        ctrl.$setValidity('noMatch', !noMatch);
        return viewValue;
      });
    }
  }
});

app.directive('useFormError',['$log',function($log){
  return {
    restrict:'A',
    require :['?ngModel','^form'],
    scope   :{
      useFormError      :'@',
      useErrorExpression:"=",
      useErrorInput     :"=?",
    },
    link    :function(scope,elem,attrs,ctrls){
      //We expect that the directive will be applied either on the ng-model, ng-form or another element as an attribute
      var validityObject=scope.useErrorInput || ctrls[0] || ctrls[1];
      if(validityObject && angular.isFunction(validityObject.$setValidity)){
        if(!angular.isDefined(scope.useFormError))
          $log.error('You must define a key for the form input "'+attrs.useErrorInput+'"');
        //We watch the changes of expression
        scope.$watch('useErrorExpression',function(newVal){
          $log.debug('Key: '+attrs.useFormError+'. Expression: '+attrs.useErrorExpression+' is '+newVal);
          if(newVal)
            validityObject.$setValidity(scope.useFormError,false);
          else
            validityObject.$setValidity(scope.useFormError,true);
        });
      }else
        $log.error('Form input "'+attrs.useErrorInput+'" not defined for the key: "'+scope.useFormError+'"');
    }
  };
}]);

var SPECIAL_CHAR = /^[a-zA-Z0-9\!\@\#\$\%\^\\\&\*\(\)\-\_\=\+]*$/;
//Password Special Character Filter
app.directive('specialCharC', function () {
  return {
    require: 'ngModel',
    link: function (scope, elm, attrs, ctrl) {
      ctrl.$validators.specialCharC = function(modelValue, viewValue) {
        ctrl.$setValidity('haveSpecialChar', SPECIAL_CHAR.test(viewValue));

        if (ctrl.$isEmpty(modelValue)) {
          // consider empty models to be valid
          return true;
        }

        if (SPECIAL_CHAR.test(viewValue)) {
          // it is valid
          return true;
        }

        // it is invalid
        return false;
      };
    }
  }
});

app.directive('userNameDuplicated', function (CsrfToken, $window) {
  return {
    require: 'ngModel',
    link: function (scope, elm, attrs, ctrl) {
      var original;
      ctrl.$formatters.unshift(function (modelValue) {
        original = modelValue;
        return modelValue;
      });

      ctrl.$parsers.push(function (viewValue) {
        if (viewValue != undefined) {
          if (viewValue.length >= 4) {
            var url = "/api/player/CheckDuplicateName";
            var param = { MemberID: viewValue };

            CsrfToken.HttpRequest('POST', url, param).success(function (data) {
              if (data.result == 0) {
                if(data.csrf){
                  swal({
                    title: "캐시 및 쿠키 삭제 후",
                    text: "브라우저를 새로고침해 주세요",
                    className: "csrf-swal",
                    icon: "error",
                    showCancelButton: false,
                    confirmButtonClass: "#7cd1f9",
                    confirmButtonText: "OK",
                    closeOnConfirm: false
                  }).then(function(confirm){
                    if (confirm) {
                      $window.location.href = "/#/";
                      $window.location.reload();
                    }
                  });
                } else {
                  ctrl.$setValidity('duplicated', false);
                }
              } else {
                ctrl.$setValidity('duplicated', true);
              }
              ctrl.$setValidity('minlength', true);
            });
            return viewValue;
          } else {
            ctrl.$setValidity('minlength', false);
            return viewValue;
          }
        } else {
          ctrl.$setValidity('minlength', false);
          return viewValue;
        }
      })
    }
  };
});

app.directive('referrerCheck', function (CsrfToken,$window) {
  return {
    require: 'ngModel',
    link: function (scope, elm, attrs, ctrl) {
      var original;
      ctrl.$formatters.unshift(function (modelValue) {
        original = modelValue;
        return modelValue;
      });

      ctrl.$parsers.push(function (viewValue) {
        if (viewValue != "") {
          if (viewValue.length >= 4) {
            var url = "/api/player/CheckDuplicateName";

            var param = { MemberID: viewValue }

            CsrfToken.HttpRequest('POST', url, param).success(function (data) {
              if (data.result == 0) {
                if(data.csrf){
                  swal({
                    title: "캐시 및 쿠키 삭제 후",
                    text: "브라우저를 새로고침해 주세요",
                    className: "csrf-swal",
                    icon: "error",
                    showCancelButton: false,
                    confirmButtonClass: "#7cd1f9",
                    confirmButtonText: "OK",
                    closeOnConfirm: false
                  }).then(function(confirm){
                    if (confirm) {
                      $window.location.href = "/#/";
                      $window.location.reload();
                    }
                  });
                }
                else{
                  ctrl.$setValidity('duplicated', true);
                }
              } else {
                ctrl.$setValidity('duplicated', false);
              }
            });
            return viewValue;
          } else {
            ctrl.$setValidity('duplicated', false);
            return viewValue;
          }
        } else {
          ctrl.$setValidity('required', true);
          // ctrl.$setValidity('duplicated', true);
          // ctrl.$setPristine();
          return viewValue;
        }
      })
    }
  };
});

app.directive('format', ['$filter', function ($filter) {
  return {
    require: '?ngModel',
    link: function (scope, elem, attrs, ctrl) {
      if (!ctrl) return;

      ctrl.$formatters.unshift(function (a) {
        if (attrs.format == "numberDecimal" || attrs.format == "number") {
          return $filter("number")(ctrl.$modelValue)
        }
      });
      ctrl.$parsers.unshift(function (viewValue) {
        if (viewValue == "NaN") return 0;
        if (attrs.format == "numberDecimal") {
          var plainNumber = viewValue.replace(/[^\d|\-+|\d\.\d|\d\.+]/g, '');
          if (viewValue.slice(-1) != ".") {
            elem.val($filter("number")(plainNumber));
          }
        } else if (attrs.format == "number") {
          var plainNumber = viewValue.replace(/[^\d|\-+|\.+]/g, '');
          elem.val($filter("number")(plainNumber));
        }
        return plainNumber;
      });
    }
  };
}]);

app.controller("NavController", function ($scope, $rootScope, $location, $route, $window) {
  $scope.isActive = function (viewLocation) {
    return viewLocation === $location.path();
  };
  $scope.$route = $route;
  $scope.getActiveClass = function (location) {
    $scope.setActiveClass = location;
  };

  $rootScope.gotoUrl = function(url){
    if(!$rootScope.loggedIn && (url == "/tv" || url == 'graph')){
      return $scope.displayLogin();
    }
    if(url == '/tv'){
      return $window.open("http://www.max-890.com/#/tv", "_blank");
    }
    $location.url(url);
  }
});

app.controller('CommonController', function (Idle,CsrfToken, $scope, $rootScope, $timeout, $window, $http, loggedInStatus, $interval, ngDialog, $cookies, $sce, SweetAlert, ccCurrencySymbol, $translate, $location, $filter) {

  $scope.$on('IdleStart', function() {
    // the user appears to have gone idle
    if($rootScope.loggedIn){
      $rootScope.logoutToken();
    }
  });

  $scope.isTokenExpired = false;

  let debounce;
  $('html body').click(function (e) {
    if ($rootScope.checkLogoutStatus) {
      return e.preventDefault();
    }
    if ($rootScope.loggedIn && !$scope.isTokenExpired) {
      clearTimeout(debounce);
      debounce = setTimeout(
        function () {
          $rootScope.CheckMemberToken()
        }, 1000
      );
    }
  });

  $rootScope.CheckMemberToken = function (){
    var url = '/api/player/CheckMemberToken';
    $http.get(url).success(function (data){
      if(data.result == 201){
        $scope.isTokenExpired = true;
        swal(data.message, "", "error").then(function (confirm){
          if(confirm){
            $rootScope.logoutToken();
          }
        });
      }
    });
  }

  $rootScope.logoutToken = function () {
    $http.get("/api/player/Logout").success(function (data) {
      if (data.result == 1) {
        if (bowser.msie && bowser.version <= 8) {
          alert("로그아웃 되었습니다");
        } else {
          SweetAlert.swal("로그아웃 되었습니다", "", "success");
        }
        loggedInStatus.setLoggedOutStatus();
        $window.location.reload();
      } else {
        loggedInStatus.setLoggedOutStatus();
        $window.location.reload();
      }
    });
  }

  $rootScope.getAgentProductCasinoGameList = {};
  $rootScope.userCurrency = "KRW";
  $rootScope.cc_currency_symbol = ccCurrencySymbol;
  $rootScope.agentGspList = [];

  $rootScope.announceList = {};
  $rootScope.eventList = {};
  $rootScope.realTimeTransactionList = [];
  $rootScope.readTitle = "";
  $rootScope.readDate = "";
  $rootScope.readContents = "";
  $rootScope.totalBalance = "Loading";
  $scope.getNotice = false;
  $scope.isProcessing = false;
  $scope.isLoadingPopup = false;

  $rootScope.techContactNumber = "";
  $rootScope.bankContactNumber = "";
  $rootScope.emailContact = "";
  $rootScope.messengerContact1 = "";
  $rootScope.messengerContact2 = "";

  // !!! Unique id required
  $scope.multiplePopup = [
    { id: 'mp-01', image: 'popup-banner-04-new.jpg'},
    { id: 'mp-02', image: 'popup-banner-01-new.jpg'},
    { id: 'mp-03', image: 'popup-banner-03-new.jpg'},
    { id: 'mp-04', image: 'popup-banner-02.jpg'},
  ];

  /*$scope.multiplePopup2 = [
    { id: 'mp-05', image: 'popup-banner-10.jpg'},
  ];*/

  $timeout(function () {
    if (!$cookies.get('notTodayNewPharaoh-new14')) {
      ngDialog.open({
        template: '/popup/multiple-popup-2.html',
        controller: 'PharaohNewNoticePopup14',
        className: 'ngdialog-theme-default ngdialog-movie-14',
        showClose: false,
        closeByEscape: false,
        closeByDocument: false,
        scope: $scope,
        preCloseCallback: function () {
          setTimeout(function () {
            $(".ngdialog").animate({scrollTop: 0});
          }, 300)
        }
      });
    }
  });

  function getNotTodayCookie(listArr) {
    // Get popups that are in cookie list
    var cookiesArr = listArr.map(function(list) {
      if($cookies.get('notToday-' + list.id)) { return list.id }
    });

    // Filter to remove empty elements from array
    return cookiesArr.filter(function(x) { return x});
  }

  $scope.displayMultiplePopups = function(listArr) {
    if(!listArr) { return }
    // Check if all popups are in the cookie
    if(getNotTodayCookie(listArr).length === listArr.length) { return }

    ngDialog.open({
      template: 'popup/multiple-popup.html',
      controller: 'MultiplePopupController',
      className: 'ngdialog-theme-default ngdialog-multiple-popup',
      showClose: false,
      closeByEscape: false,
      closeByDocument: false,
      scope: $scope,
      data: {
        lists: listArr
      },
      preCloseCallback: function () {
        window.scrollTo(0, 0);
      }
    });
  };

  $scope.displayNewPopup = function () {
    if (!$cookies.get('notToday-new')) {
      $scope.movieOpen = ngDialog.open({
        template: 'popup/notice-popup-1.php',
        controller: 'MovieController',
        className: 'ngdialog-theme-default',
        showClose: true,
        closeByEscape: false,
        closeByDocument: false,
        scope: $scope
      });
    }
  }

  $rootScope.getBalance = function (reload) {
    if (reload) {
      $("#preloader").show();
    }
    if (!$scope.isProcessing) {
      $scope.isProcessing = true;
      var url="../api/finance/CheckMemberBalanceAsync";

      CsrfToken.HttpRequest('GET',url,'').success(function (data) {
        if(data.csrf){
          swal({
            title: "캐시 및 쿠키 삭제 후",
            text: "브라우저를 새로고침해 주세요",
            className: "csrf-swal",
            icon: "error",
            showCancelButton: false,
            confirmButtonClass: "#7cd1f9",
            confirmButtonText: "OK",
            closeOnConfirm: false
          })
        } else {
          angular.forEach($rootScope.agentGspList, function (val) {
            if (data.list[val.gspNo] != undefined) {
              val.amount = data.list[val.gspNo].Balance;
            } else {
              val.amount = 0;
            }
          });
          if ($rootScope.loggedIn) {
            $rootScope.totalBalance = data.list['All'].Balance;
          }
        }
      }).error(function (data, result) {
        console.error('Repos error', result, data);
      })["finally"](function () {
        $scope.isProcessing = false;
        $("#preloader").hide();
      });
    }
  };

  $scope.gameCategory= [
    {'category': 'live'},
    {'category': 'slot'},
    {'category': 'Others'},
    {'category': 'Poker'},
  ];

  $scope.displayGames = function (category) {
    $scope.isLoadingPopup = true;

    if (category == 'hotel') {
      return $rootScope.comingSoon();
    }

    if (category == 'Poker') {
      $rootScope.activeCategory = category;
      return $scope.playGame('1070', 'live', '', 'UserId');
    }

    if ($scope.isLoadingPopup == true) {
      $('.click-disable').addClass('disable-event');
      $rootScope.activeCategory = category;
      ngDialog.open({
        template: 'popup/games-popup.php',
        controller: '',
        className: 'ngdialog-theme-default ngdialog-gamespopup',
        closeByEscape: false,
        closeByDocument: false,
        scope: $scope,
        preCloseCallback: function () {
          $scope.isLoadingPopup = false;
          $('.click-disable').removeClass('disable-event');
        }
      });
    }
  }

  $http.get("/api/system/gamelist/gamebuttons.json")
    .success(function (data) {
      $scope.gameButtons = data;
    });
  $scope.gameButtonFilter = function(category){
    if(category.category == $scope.activeCategory || category.category2 == $scope.activeCategory || category.category3 == $scope.activeCategory){
      return true;
    }
  }

  $http.get("/api/system/gamelist/footer.json")
    .success(function (data) {
      $rootScope.FooterData = data;
    });


  $scope.combinedMaintenance = function (agentGsp) {
    if (agentGsp.amount == '점검중') {
      return agentGsp.gspName + " - 점검중";
    } else {
      return $filter('translate')(agentGsp.gspName);
    }
  };

  $scope.combinedMaintenanceByCurrency = function (agentGsp) {
    if (agentGsp.Maintenance == 'Y') {
      return false;
    } else {
      return true;
    }
  };

  $scope.maintenanceFilter = function (agentGsp) {
    if (agentGsp.amount == '점검중') {
      return false;
    } else {
      return true;
    }
  };

  $scope.translateWalletCategory = function (agentGsp) {
    return $filter('translate')(agentGsp.category);
  };

  $rootScope.GetPromotionHistoryCommon = function () {
    var url = "/api/player/GetPromotionHistory";
    $http({
      method: 'GET',
      url: url,
      headers: {
        'Content-Type': 'application/x-www-form-urlencoded'
      } // set the headers so angular passing info as form data (not request payload)
    }).success(function (data) {
      $scope.getPromotionFromCommon = data.promotion;
    })["finally"](function () {
    });
  };
  $rootScope.GetPromotionHistoryCommon();

  $scope.getActiveCategory = function (gspNo, category, gameId, gspName, theme) {
    if(category == "Others" && gspNo == 1052){
      return $scope.playGame(gspNo, 'Ltlottery', '', '12');
    }
    if(gspNo == 1031){
      return;
    }
    if(gspNo == 1070 || gspNo == 1038){
      return $rootScope.comingSoon();
    }
    if(category == "Others" && gameId == "6"){
      return $scope.playGame(gspNo, 'fish', gameId);
    }
    if(category == "Others" && gspNo != 1070 && gspNo != 1020 && gspNo != 1012 && gspNo != 1048){
      return $scope.playGame(gspNo, 'minigame', gameId ,'');
    }

    if(category == "Others" && gameId == "110"){
      return $scope.playGame(gspNo, 'live', gameId ,'');
    }

    if(category == "Others" && gspNo != 1020){
      return $scope.playGame(gspNo, 'live');
    }


    if(category == 'live'){
      if(gameId=="microPopup"){
        // return $scope.microPopup();
        return $scope.playGame('1112','live','1930');
      }
      return $scope.playGame(gspNo, 'live', gameId , theme);
    }

    else if(category == 'slot'){
      $('.game-button-container').css("display", "none");
      $('.slots-games-container').css("display", "block");
      $rootScope.loadSlot(gspNo);
      $rootScope.gspName = gspName;
      return $rootScope.activeSlotGsp = gspNo;
    }
    else if(category == 'sports'){
      ngDialog.close();
      return $rootScope.setActiveSportsGsp(gspNo);

    }
    else if(category == 'Others' && gspNo == 1020){
      return $scope.playGame(gspNo, 'live', gameId);
    }
  }

  /*sports view*/
  $scope.setActiveSportsGsp = function (gspNo) {

    $http.get("/api/system/gamelist/gamebuttons.json")
      .success(function (data) {
        $rootScope.gameButtons = data;
      });

    if (gspNo == "" || gspNo == undefined || gspNo == 9999) {
      $rootScope.comingSoon();
      return;
    }
    if ($rootScope.loggedIn != true) {
      $scope.displayLogin();
      return;
    }
    $rootScope.activeSportsGsp = gspNo;
    $location.url('/view-sports');
  }

  $rootScope.checkUnreadComment = function (type, announceNo) {
    $scope.countUnread = 0;
    var url = "/api/operation/GetBoardComment?type=" + type + "&&code=" + announceNo;
    $http({
      url: url,
      data: $.param({
        "type": type,
        "code": announceNo,
      }), // pass in data as strings
      headers: {
        'Content-Type': 'application/x-www-form-urlencoded'
      } // set the headers so angular passing info as form data (not request payload)
    }).success(function (data) {
      angular.forEach(data.content, function (value, key) {
        if (value.WriteStatus == "N") {
          $scope.countUnread++;
        }
      });
      if ($scope.countUnread > 0) {
        $('.board-' + announceNo).removeClass("hidden");
      } else {
        $('.board-' + announceNo).addClass("hidden");
      }
      $scope.countUnread = 0;
    })
  }

  $rootScope.readBoardContent = function (type, announceNo, comment, index) {
    if (comment == undefined) {
      comment = false;
    }

    $rootScope.readCommentDate = "";
    $rootScope.readComment = "";
    $rootScope.readBoardCode = "";
    $rootScope.readCount = "";
    $rootScope.readTitle = "";
    $rootScope.readDate = "";
    $rootScope.readContents = "";

    if (index) {
      $rootScope.readCommentDate = [];
      $rootScope.readComment = [];
      $rootScope.readBoardCode = [];
      $rootScope.readCount = [];
      $rootScope.readTitle = [];
      $rootScope.readDate = [];
      $rootScope.readContents = [];
    }

    var url = "/api/operation/GetBoardDescription";
    var param =  {
      "type": type,
      "code": announceNo,
      "comment": comment
    };

    CsrfToken.HttpRequest('POST',url,param).success(function (data) {
      if(data.csrf){
        swal({
          title: "캐시 및 쿠키 삭제 후",
          text: "브라우저를 새로고침해 주세요",
          className: "csrf-swal",
          icon: "error",
          showCancelButton: false,
          confirmButtonClass: "#7cd1f9",
          confirmButtonText: "OK",
          closeOnConfirm: false
        })
      } else {
        if (index) {
          $rootScope.readBoardCode[index] = data.content.BoardCode;
          $rootScope.readCount[index] = data.content.ViewCount;
          $rootScope.readTitle[index] = data.content.Subject;
          $rootScope.readDate[index] = data.content.WriteDate;
          $rootScope.readContents[index] = $sce.trustAsHtml(data.content.Contents);
        } else {
          $rootScope.readBoardCode = data.content.BoardCode;
          $rootScope.readCount = data.content.ViewCount;
          $rootScope.readTitle = data.content.Subject;
          $rootScope.readDate = data.content.WriteDate;
          $rootScope.readContents = $sce.trustAsHtml(data.content.Contents);
          if (comment) {
            $rootScope.readCommentDate = data.content['comment'][0].WriteDate;
            $rootScope.readComment = data.content['comment'];
          }
        }
      }
    }).error(function (data, status) {
      console.error('Repos error', status, data);
    })["finally"](function () {
      $rootScope.isRead = true;
    });
  };

  $rootScope.displayNoticeToday = function() {
    angular.forEach($rootScope.announceList, function (val) {
      if (val.PopUp == 'y' && !$scope.getNotice) {
        $rootScope.anouncementPopup = val;
        $scope.getNotice = true;
        if (!$cookies.get('notToday')) {
          ngDialog.open({
            template: 'popup/notice.php',
            controller: 'NoticeController',
            className: 'ngdialog-theme-default ngdialog-notice',
            showClose: true,
            closeByEscape: false,
            closeByDocument: false,
            scope: $scope
          });
        }
      }
    });
  };

  $scope.ShowDirectMessageDetail = function (DirectMessage) {
    $rootScope.DMHideNew[DirectMessage.DMStatusIDX] = true;
    $rootScope.showDirectMessageValues = DirectMessage;

    $http.get("/api/operation/GetDirectMessageDetail?code=" + DirectMessage.DMStatusIDX)
      .success(function (data) {
        $rootScope.UnreadDM = data.list.UnreadDM;
        $rootScope.DMReadDate[DirectMessage.DMStatusIDX] = data.list.DMReadDate;
      }).error(function (data, result) {
      console.error('Repos error', result, data);
    })
  };

  if (!$cookies.get("POPUP_COUNT")){
    $cookies.put("POPUP_COUNT", '2');
  }

  if (!$cookies.get("POPUP_CLOSE") || $cookies.get("POPUP_CLOSE") == 0){
    $cookies.put("POPUP_CLOSE", $cookies.get("POPUP_COUNT"));
  }


  $scope.trustAsHtml = $sce.trustAsHtml;

  $scope.microPopup = function () {
    if (!$rootScope.loggedIn) {
      $scope.displayLogin();
      return
    }
    ngDialog.open({
      template: 'popup/micro-popup.php',
      controller: '',
      className: 'ngdialog-theme-default ngdialog-microgaming',
      showClose: true,
      closeByEscape: false,
      scope: $scope,
      preCloseCallback: function () {
        $scope.setActive = undefined;
      }
    });
  };

  $scope.playGame = function (gspNo, productType, gameId, theme, chatOpt, other, gameName, iFrame) {
    if (gspNo == '1005' && productType == 'live' && gameId == 'micropopup') {
      return $scope.microPopup();
    }

    if (gspNo == 9999) {
      $scope.comingSoon();
      return;
    }

    if ($rootScope.loggedIn) {
      $rootScope.isOdds = false;
      var url = "";
      var size = "";
      var scroll = "scrollbars=1";
      if (productType == "sports") {
        if (gspNo == 1031) {
          url = "/api/player/PlayGame?gspNo=" + gspNo + "&productType=" + productType;
          $rootScope.sportIURL = $sce.trustAsResourceUrl(url);
        } else if (gspNo == 1059) {
          $rootScope.isOdds = true;
          url = "/api/player/PlayGame?gspNo=" + gspNo + "&productType=" + productType + "&gameId=" + gameId;
          $rootScope.sportIURL = $sce.trustAsResourceUrl(url);
        } else {
          url = "/api/player/PlayGame?gspNo=" + gspNo + "&productType=" + productType + "&gameId=" + gameId;
          $rootScope.sportIURL = $sce.trustAsResourceUrl(url);
        }
      } else {
        if (productType == 'live' && gameId == 'Desktop') {
          url = "/api/player/PlayGame?gspNo=" + gspNo + "&productType=" + productType + "&gameId=" + gameId;
          size = "width=1024, height=592, scrollbars=no, resizable=no ,toolbar=no,titlebar=no";
          var popupWindow = window.open(url, 'live', size);
        }
        if (productType == "live" || productType == "playCheck" || productType == "fun" || productType == "Ltlottery") {
          if (gspNo == 1031) {
            productType = "sports";
            url = "/api/player/PlayGame?gspNo=" + gspNo + "&productType=" + productType;
            var dualScreenLeft = window.screenLeft != undefined ? window.screenLeft : screen.left;
            var dualScreenTop = window.screenTop != undefined ? window.screenTop : screen.top;
            width = "1300";
            height = "1004";
            var x = ((screen.width / 2) - (width / 2)) + dualScreenLeft;
            var y = ((screen.height / 2) - (height / 2)) + dualScreenTop;
            var total_size = "width=" + width + ",height=" + height + ",left=" + x + ",top=" + y;
            var popupWindow = window.open(url, "", total_size).focus();

            return;
          }
          if (gspNo == 1012) {
            url = "/api/player/PlayGame?gspNo=" + gspNo + "&productType=" + productType;
            size = "width=1024, height=592";
          } else if (gspNo == 1060) {
            url = "/api/player/PlayGame?gspNo=" + gspNo + "&productType=" + productType;
            size = "width=1024, height=592, scrollbars=yes";
          } else if (gspNo == 1030) {
            url = "/api/player/PlayGame?gspNo=" + gspNo + "&productType=" + productType;
            size = "width=985, height=592";
          } else if (gspNo == 1022 || gspNo == 1039) {
            url = "/api/player/PlayGame?gspNo=" + gspNo + "&productType=" + productType;
            size = "width=1240, height=775";
          } else if (gspNo == 1009 || gspNo == 1019) {
            url = "/api/player/PlayGame?gspNo=" + gspNo + "&productType=" + productType;
            size = "width=1024, height=580";
          } else if (gspNo == 1023) {
            url = "/api/player/PlayGame?gspNo=" + gspNo + "&productType=" + productType;
            size = "width=1300, height=775";
          } else if (gspNo == 1026) {
            url = "/api/player/PlayGame?gspNo=" + gspNo + "&productType=" + productType;
            size = "width=1262, height=711";
          } else if (gspNo == 1005 || gspNo == 1036 || gspNo == 1055 || gspNo == 1088 || gspNo == 1112 || gspNo == 1045) {
            url = "/api/player/PlayGame?gspNo=" + gspNo + "&productType=" + productType + "&gameId=" + gameId;
            size = "width=1024, height=768";
          } else if (gspNo == 1058) {
            url = "/api/player/PlayGame?gspNo=" + gspNo + "&productType=" + productType + "&gameId=" + gameId + "&gameType=" + theme;
            size = "width=1240, height=775";
          } else if (gspNo == 1035 || gspNo == 1040 || gspNo == 1049) {
            url = "/api/player/PlayGame?gspNo=" + gspNo + "&productType=" + productType;
            size = "width=1240, height=775";
          } else if (gspNo == 1020) {
            url = "/api/player/PlayGame?gspNo=" + gspNo + "&productType=" + productType + "&gameId=" + gameId;
            size = "width=1280, height=1000";
          } else if (gspNo == 1057) {
            url = "/api/player/PlayGame?gspNo=" + gspNo + "&productType=" + productType + "&gameId=" + gameId;
            size = "width=1350, height=1240";
          } else if (gspNo == 1118 ) {
            url = "/api/player/PlayGame?gspNo=" + gspNo + "&productType=" + productType + "&gameId=" + gameId + "&accLevel=" + theme;
            size = "width=1366, height=768";
          } else if(gspNo == 1070) {
            url = "/api/player/PlayGame?gspNo=" + gspNo + "&productType=" + productType + "&gameId=" + gameId + "&accLevel=" + theme;
            size = "width=1099, height=979";
          } else if (gspNo == 1153) {
            url = "/api/player/PlayGame?gspNo=" + gspNo + "&productType=" + productType + "&gameId=" + gameId;
            size = "width=1366, height=795";
          } else if (gspNo == 1052) {
            url = "/api/player/PlayGame?gspNo=" + gspNo + "&productType=" + productType + "&gameId=" + gameId + "&gameType=" + theme;
            size = "width=1360, height=768";
          } else {
            url = "/api/player/PlayGame?gspNo=" + gspNo + "&productType=" + productType;
            size = "width=1024, height=768";
          }

        } else if (productType == "slot" || productType == "game" || productType == "minigame") {
          if (gspNo == 1005 || gspNo == 1004 || gspNo == 1011 || gspNo == 1038 || gspNo == 1036) {
            url = "/api/player/PlayGame?gspNo=" + gspNo + "&productType=" + productType + "&gameId=" + gameId;
            size = "width=1024, height=592";
          } else if (gspNo == 1032) {
            url = "/api/player/PlayGame?gspNo=" + gspNo + "&productType=" + productType + "&gameId=" + gameId;
            size = "width=1300, height=840";
          } else if (gspNo == 1012) {
            url = "/api/player/PlayGame?gspNo=" + gspNo + "&productType=" + productType + "&gameId=" + gameId;
            size = "width=1300, height=800";
          } else if (gspNo == 1034) {
            url = "/api/player/PlayGame?gspNo=" + gspNo + "&productType=" + productType + "&gameId=" + gameId;
            size = "width=1200, height=800";
          } else if (gspNo == 1073) {
            url = "/api/player/PlayGame?gspNo=" + gspNo + "&productType=" + productType + "&gameId=" + gameId;
            size = "width=840, height=1150";
          } else if (gspNo == 1098) {
            url = "/api/player/PlayGame?gspNo=" + gspNo + "&productType=" + productType + "&gameId=" + gameId + "&GameName=" + gameName;
            size = "width=1024, height=592";
          } else if (gspNo == 1142) {
            url = "/api/player/PlayGame?gspNo=" + gspNo + "&productType=" + productType + "&gameId=0";
            size = "width=1366, height=950";
          } else if (gspNo == 1052) {
            theme = 5
            url = "/api/player/PlayGame?gspNo=" + gspNo + "&productType=" + productType + "&gameType=" + theme + "&gameId=" + gameId;
            size = "width=1360, height=768";
          } else if (gspNo == 1169) {
            url = "/api/player/PlayGame?gspNo=" + gspNo + "&productType=" + productType + "&gameType=" + theme +  "&gameId=" + gameId ;
            size = "width=1609, height=960";
          }  else if (gspNo == 1176) {
            url = "/api/player/PlayGame?gspNo=" + gspNo + "&productType=" + productType + "&gameId=" + gameId;
            size = "width=1369, height=826";
          }
          else {
            url = "/api/player/PlayGame?gspNo=" + gspNo + "&productType=" + productType + "&gameId=" + gameId;
            size = "width=1024, height=768";
          }
        } else if (productType == "etc" || productType == "fish") {
          url = "/api/player/PlayGame?gspNo=" + gspNo + "&productType=" + productType;
          size = "width=1024, height=682";
        }

        var target = "";
        if (productType == 'live') {
          target = gspNo + productType;
        } else if (productType == 'slot') {
          target = productType;
        } else if (productType == 'playCheck' && gspNo == 1005) {
          target = gspNo + "playCheck";
        } else {
          target = gspNo + Math.random();
        }

        //Center Popup
        if((navigator.userAgent.indexOf("MSIE") != -1 ) || (!!document.documentMode == true )) //IF IE > 10
        {
          var popupWindow = window.open(url, target, size).focus();
        }
        var dualScreenLeft = window.screenLeft != undefined ? window.screenLeft : screen.left;
        var dualScreenTop = window.screenTop != undefined ? window.screenTop : screen.top;

        var width = size.slice(6,10);
        var height = size.slice(19,22);

        if(gspNo == 1020){
          width = "1280";
          height="1400"
        } else if(gspNo == 1073){
          width = "840";
          height="1150"
        } else if (gspNo == 1108) {
          width = "1366";
          height = "818"
        } else if (gspNo == 1106) {
          width = "1425";
          height = "818"
        } else if (gspNo == 1030) {
          width = "1323";
          height = "818"
        } else if (gspNo == 1031) {
          width = "1041";
          height = "986"
        } else if (gspNo == 1125) {
          width = "500";
          height = "890"
        } else if (gspNo == 1096) {
          width = "1260";
          height = "818"
        } else if (gspNo == 1044) {
          width = "1288";
          height = "870"
        } else if (gspNo == 1091) {
          width = "1387";
          height = "872"
        } else if (gspNo == 1056) {
          width = "1129";
          height = "825"
        }

        var x = ((screen.width/2) - (width/2)) + dualScreenLeft ;
        var y = ((screen.height/2) -(height/2))+ dualScreenTop ;
        var total_size="width="+width+",height="+height+",left="+x+",top="+y;

        if(gspNo == 1027 || gspNo == 1004 || gspNo == 1006 || gspNo == 1022 || gspNo == 1025){
          $.colorbox({iframe:true,href:url, width:"80%", height:"80%", overlayClose: false});
          ngDialog.close();
          return;
        }

        var popupWindow = window.open(url, target, total_size);
        popupWindow.focus();

        if (gspNo == 1150 || gspNo == 1153) {
          var pollTimer = window.setInterval(function () {
            if (popupWindow.closed !== false) { // !== is required for compatibility with Opera
              window.clearInterval(pollTimer);
              CallCloseSession();
            }
          }, 200);
        }

        function CallCloseSession() {
          window.setTimeout(function () {
            if (popupWindow.closed) {
              var closeUrl = url.concat("&isClose=true");
              $http.get(closeUrl).success(function (data) {
                SendCloseSession(data.MemberId, data.SessionId, data.GameCode)
              });
            }
          }, 1);
        }
      }
    } else {
      ngDialog.open({
        template: '/popup/login.php',
        controller: 'LoginController',
        className: 'ngdialog-theme-default ngdialog-login',
        scope: $scope
      });
    }

  };

  function SendCloseSession(memberId, sessionId, gspCode) {

    var url = isDevelopUrl() ? "https://dev.aplus-api.com/api/close/session" : "http://v2.aplus-api.com/api/close/session";
    var param = "?memberId=" + memberId + "&sessionId=" + sessionId + "&gspCode=" + gspCode;
    url = url.concat(param);
    $http.get(url).success(function (data) {
      console.log(data)
    });

  }

  function isDevelopUrl() {
    var server = window.location.hostname;
    var pattern = /[a-z0-9]+\.develop888\.com/;

    return pattern.test(server);
  }

  $scope.setLang = function (langKey) { //selected language
    $rootScope.currentLang = langKey;
    $cookies.get("selectedLanguage");
    var now = new Date(),
      // this will set the expiration to 12 months
      exp = new Date(now.getFullYear() + 100, now.getMonth(), now.getDate());
    // Setting a cookie
    $cookies.put("selectedLanguage", langKey, {expires: exp});
    $rootScope.languageSelector(langKey);
    $translate.use(langKey);
  };

  $rootScope.languageSelector = function (langKey) {
    var font = 'kr.css';
    var langName = " 한국어";
    var lang = langKey.substring(0, 2);

    if (lang == "en") {
      font = "en.css";
      langName = " ENGLISH";
    } else if (lang == "ko") {
      font = "kr.css";
      langName = " 한국어";
    } else if (lang == "ja") {
      font = "jp.css";
      langName = " 日本語";
    } else if (lang == "zh") {
      font = "cn.css";
      langName = " 中文";
    } else if (lang == "id") {
      font = "id.css";
      langName = " INDONESIA";
    } else {
      font = "kr.css";
      langName = " 한국어";
    }

    $('#language-flag').html('<i class="icon-lang language-' + langKey.substring(0, 2) + '"></i><span>' + langName + '</span><span class="caret"></span>');

    var fileref = document.createElement("link");
    fileref.setAttribute("rel", "stylesheet");
    fileref.setAttribute("href", "/common/css/languages/" + font);

    if (typeof fileref != "undefined") {

      $("link[href*='/common/css/languages/kr.css']").remove();
      $("link[href*='/common/css/languages/jp.css']").remove();
      $("link[href*='/common/css/languages/cn.css']").remove();
      $("link[href*='/common/css/languages/en.css']").remove();
      $("link[href*='/common/css/languages/id.css']").remove();

      document.getElementsByTagName("head")[0].appendChild(fileref);
    }
    return font;
  };

  $scope.checkSession = function () {
    $http.get("/api/player/GetNewMemberInfo")
      .success(function (data) {
        /*WILL DISABLE IF HAS DATA*/
        if (data.result != 1) {
          if (data.result == 207) {
            $http.get("/api/player/Logout").success(function (data) {
              if (data.result == 1) {
                if (bowser.msie && bowser.version <= 8) {
                  alert(data.message);
                } else {
                  $translate([data.message, "YouHaveBeenSignedOut"]).then(function (translations) {
                    SweetAlert.swal(translations.YouHaveBeenSignedOut, translations[data.message], "success");
                  });
                }
                loggedInStatus.setLoggedOutStatus();
                $window.location.reload();
              } else {
                loggedInStatus.setLoggedOutStatus();
                $window.location.reload();
              }
            });
          }
        } else {
          if (data.alert) {
            if (bowser.msie && bowser.version <= 8) {
              alert(data.message);
            } else {
              $translate([data.message, "PleaseTryAgain"]).then(function (translations) {
                SweetAlert.swal(translations.PleaseTryAgain, translations[data.message], "success");
              });
            }
          }
        }
        /*WILL DISABLE IF HAS DATA*/
        $scope.aff_user = data.bonus.AffUser;
        $rootScope.UnreadDM = data.bonus.UnreadDM;

        if ($rootScope.agentGspList == undefined) {
          $scope.getBalance();
        }

        if ($rootScope.agentGspCount != data.GameList.count) {
          $rootScope.agentGspList = data.GameList.data;
          $rootScope.agentGspCount = data.GameList.count;
        }

        $scope.getBalance();
      }).error(function (data, result) {
      console.error('Repos error', result, data);
    })["finally"](function () {
      $scope.isProcessing = false;
    });
  };

  // Timer Function

  // INFO: Indicate the date and time (optional) of the target schedule on var endD. The format would be: yyyy/mm/dd hh:mm

  /*var d = new Date();
  $scope.date = d.getFullYear() + '-' +
    ("0" + (d.getMonth() + 1)).slice(-2) + '-' +
    ("0" + d.getDate()).slice(-2);
  $scope.time = d.getHours() + ':' + d.getMinutes();

  var startD = "2023-04-28";

  let multiplePopup = "";
  let multiplePopup2 = "";

  multiplePopup = $scope.multiplePopup;
  multiplePopup2 = $scope.multiplePopup2;

  if ($scope.date < startD) {
    multiplePopup = $scope.multiplePopup
  } else {
    multiplePopup = $scope.multiplePopup1
  }*/

  $scope.init = function (isLogin) {
    $scope.setLang('ko_KR');
    $scope.displayMultiplePopups($scope.multiplePopup);
    if (isLogin) {
      loggedInStatus.setLoggedInStatus();
      $scope.checkSession();
      $interval(function () {
        $scope.checkSession();
      }, 60000);//1min
    }

    if (localStorage.getItem('NG_TRANSLATE_LANG_KEY') === undefined) {
      var arrayLang = ["ko_KR"];
      var userLang = navigator.language || navigator.userLanguage; //for IE8 = navigator.userLanguage
      var u;
      for (u = 0; u < arrayLang.length; u++) {
        if (arrayLang[u].search(userLang.replace("-", "_")) === 0) {
          var browserLang = arrayLang[u].replace("-", "_");
        }
      }
      if (browserLang === undefined) {
        $rootScope.currentLang = userLang.substring(0, 2) + "_" + userLang.substring(3, 5).toUpperCase();
      } else {
        $rootScope.currentLang = browserLang;
      }
    } else {
      $rootScope.currentLang = localStorage.getItem('NG_TRANSLATE_LANG_KEY');
      if ($rootScope.currentLang == null) {
        $rootScope.currentLang = "undefined";
      }
    }

    if ($location.$$path == '/view-sports' && $rootScope.activeSportsGsp == undefined) {
      window.location = '#/';
    }
  };

  $scope.stopAlert = false;
  $scope.audio = new Audio('/common/audio/ko_KR.mp3');

  $scope.DMPlayAlert = function () {
    $scope.audio.play();
    //PLAY AUDIO EVERY MINUTE UNLESS STOP
    setInterval(function () {
      if ($scope.stopAlert == false) {
        $scope.audio.play();
      }
    }, 60000)
  }
  $scope.DMStopAlert = function () {
    $scope.stopAlert = true;
    $scope.audio.pause();
  }

  $scope.formatDate = function (date) {
    if (date) {
      var date = date.split("-").join("/");
      var dateOut = new Date(date);
      return dateOut;
    }
  };

  $scope.displayForgot = function () {
    ngDialog.open({
      template: 'popup/forgot-password.php',
      controller: 'ForgotPasswordController',
      className: 'ngdialog-theme-default ngdialog-forgot',
      scope: $scope
    });
  };

  $scope.displayLogin = function () {
    $scope.isLoadingPopup = true;

    if ($scope.isLoadingPopup == true) {
      $('.click-disable').addClass('disable-event');
      if (!$rootScope.loggedIn) {
        ngDialog.open({
          template: 'popup/login.php',
          controller: 'LoginController',
          className: 'ngdialog-theme-default ngdialog-login',
          closeByEscape: false,
          scope: $scope,
          preCloseCallback: function () {
            $scope.isLoadingPopup = false;
            $('.click-disable').removeClass('disable-event');
          }
        });
      }
    }
  };

  $scope.displaySignUp = function () {
    $scope.isLoadingPopup = true;

    if ($scope.isLoadingPopup == true) {
      $('.click-disable').addClass('disable-event');
      if ($scope.NewMember == "Y") {
        ngDialog.open({
          template: 'popup/signup.php',
          controller: 'SignUpController',
          className: 'ngdialog-theme-default ngdialog-signup',
          scope: $scope,
          closeByEscape: false,
          closeByDocument: false,
          showClose: true,
          preCloseCallback: function () {
            $scope.isLoadingPopup = false;
            $('.click-disable').removeClass('disable-event');
          }
        });
      }
      else{
        SweetAlert.swal("회원가입에 대해서는 고객센터로 문의해주세요", "감사합니다", "info");
      }
    }
  };

  $scope.closeThisDialogSignUp = function () {
    ngDialog.close();
  };

  $scope.displayPopup = function(type,tab,category) {

    if (type == 'wallet' && tab == 3) {
      $timeout(function () {
        $rootScope.CheckWithdrawTimeLimit(tab);
        if(!$scope.isBlocked){
          $rootScope.walletTab = tab;
        }
      },1000);
    }

    if (type == 'wallet') {
      return $scope.displayWallet(tab);
    }
    if(type == 'games'){
      return $scope.displayGames(category);
    }
    if(type == 'poker'){
      return $scope.playGame('1070', 'live', '', 'UserId');
    }
    if(tab =='mobile'){
      return window.location.href='/mobile/#/'
    }
    if(tab == 'liveChat'){
      return LC_API.open_chat_window();
    }
    if(tab == ''){
      return;
    }
    return $scope.displayCustomer(tab);

  }

  $scope.isBlocked = false;
  console.log($scope.$server_time);
  $rootScope.CheckWithdrawTimeLimit = function(tab){

    var start_time = new Date();
    start_time.setHours(23,0,0); // Start time
    var end_time = new Date();
    end_time.setHours(0,30,0); // End time
    var server_time = new Date();
    server_time.setHours($rootScope.server_time.slice(0, 2),$rootScope.server_time.slice(3, 5),0); //Server Time
    // server_time.setHours(0,0,0); //Edit this for manual server time and comment the servertime above this line

    // console.log(start_time);
    // console.log(end_time);
    // console.log(server_time);

    if($rootScope.WithdrawBankTimeLimitStatus == 'Y' && $rootScope.loggedIn && tab == 3 &&
      (server_time >= start_time && server_time <= end_time)){
      $scope.isBlocked = true;
      return swal("은행 점검 완료 이후 재 신청 부탁드립니다", "점검시간 : 23:00 ~ 00:30", "error")
        .then(function () { //set block status to false
          $scope.isBlocked = false;
        });
    }

  }

  $scope.displayWallet = function (tabIndex) {
    if (!$rootScope.loggedIn) {
      return $scope.displayLogin();
    }
    CsrfToken.CheckServer();

    $timeout(function () {
      $rootScope.CheckWithdrawTimeLimit(tabIndex);
      $scope.isLoadingPopup = true;

      if ($scope.isLoadingPopup == true && !$scope.isBlocked) {
        $('.click-disable').addClass('disable-event');

        $scope.selectWalletTab = tabIndex;
        ngDialog.open({
          template: 'popup/wallet.php',
          controller: 'WalletController',
          className: 'ngdialog-theme-default ngdialog-main-default ngdialog-wallet',
          closeByDocument: false,
          scope: $scope,
          preCloseCallback: function () {
            $scope.isLoadingPopup = false;
            $('.click-disable').removeClass('disable-event');
          }
        });
      }
    }, 1500);
  };

  $scope.displayCustomer = function (tabIndex) {
    $scope.isLoadingPopup = true;

    if ($scope.isLoadingPopup == true) {
      $('.click-disable').addClass('disable-event');

      if (!$rootScope.loggedIn) {
        return $scope.displayLogin();
      }
      $scope.selectCustomerTab = tabIndex;
      ngDialog.open({
        template: 'popup/customer.php',
        controller: 'CustomerController',
        className: 'ngdialog-theme-default ngdialog-main-default ngdialog-customer',
        closeByDocument: false,
        scope: $scope,
        preCloseCallback: function () {
          $scope.isLoadingPopup = false;
          $('.click-disable').removeClass('disable-event');
        }
      });
    }
  };

  $scope.displayTerms = function (tabIndex) {
    $scope.selectCustomerTab = tabIndex;
    ngDialog.open({
      template: 'popup/terms.php',
      controller: '',
      className: 'ngdialog-theme-default ngdialog-main-default',
      closeByDocument: false,
      scope: $scope
    });
  };

  $scope.displayRules = function (tabIndex) {
    $scope.pageName = 'popup/rules/rules-' + $rootScope.currentLang + '.php';
    $scope.selectRulesTab = tabIndex;
    ngDialog.open({
      template: $scope.pageName,
      controller: 'RulesController',
      className: 'ngdialog-theme-default ngdialog-rules',
      scope: $scope
    });
  };

  $rootScope.comingSoon = function () {
    if (bowser.msie && bowser.version <= 8) {
      alert("준비중입니다");
    } else {
      SweetAlert.swal("준비중입니다", "", "info");
    }
  };

  $rootScope.contactCC = function () {
    var message = 'AccessDenied';
    if (bowser.msie && bowser.version <= 8) {
      alert(message);
    } else {
      $translate([message, "ContactCustomerCenter"]).then(function (translations) {
        SweetAlert.swal(translations.ContactCustomerCenter, translations[message], "info");
      });
    }
  };

  $rootScope.setSlot = function (gspNo) {
    $rootScope.triggerLoadSlot = gspNo;
  };

  $rootScope.loadCounter = function () {
    $http.get("/api/marketing/getJackpot")
      .success(function (data) {
        $('.jackpot-odometer').jOdometer({
          increment: data.increment,
          counterStart: data.counterStart,
          counterEnd: false,
          numbersImage: 'common/images/main/slots-jackpot/odometer.png',
          spaceNumbers: 0,
          formatNumber: true,
          widthNumber: 45,
          heightNumber: 95
        });
      }).error(function (data, status) {
      console.error('Repos error', status, data);
    });
  };

  $rootScope.loadIDNCounter = function () {
    $http.get("/api/marketing/GetPokerJackpot")
      .success(function (data) {
        $('.jackpot-odometer').jOdometer({
          increment: 13.13,
          counterStart: data.total_jackpot + "." + (Math.floor(Math.random() * 9) + 1) + '' + (Math.floor(Math.random() * 9) + 1),
          counterEnd: false,
          numbersImage: 'common/images/odometer-gold.png',
          spaceNumbers: 1,
          formatNumber: true,
          widthNumber: 45,
          heightNumber: 60
        });
      }).error(function (data, status) {
      console.error('Repos error', status, data);
    });
  };

  $scope.combinedMaintenance = function (agentGsp) {
    if (agentGsp.amount == 'MAINTENANCE') {
      return agentGsp.gspName + " - MAINTENANCE";
    } else {
      return agentGsp.gspName;
    }
  };

  $scope.translateWalletCategory = function (agentGsp) {
    return $filter('translate')(agentGsp.category);
  };

  $rootScope.$on('$locationChangeSuccess', function () {
    $scope.currentPath = $location.path();
  });

  $scope.reloadWeb=function(){
    $window.location.reload();
    $location.url('/#');
  }

  /*app.directive('phoneNumberDuplicated', function ($http) {
    return {
      require: 'ngModel',
      link: function (scope, elm, attrs, ctrl) {
        var original;
        ctrl.$formatters.unshift(function (modelValue) {
          original = modelValue;
          return modelValue;
        });

        ctrl.$parsers.push(function (viewValue) {
          if (viewValue != undefined) {
            if (viewValue.length >= 4) {
              var url = "/api/player/CheckDuplicatePhone";
              $http({
                method: 'POST',
                url: url,
                data: $.param({
                  MemberPhone: viewValue
                }),
                headers: {
                  'Content-Type': 'application/x-www-form-urlencoded'
                }
              }).success(function (data) {
                if (data.result == 0) {
                  ctrl.$setValidity('duplicated', false);
                } else {
                  ctrl.$setValidity('duplicated', true);
                }
                ctrl.$setValidity('minlength', true);
              });
              return viewValue;
            } else {
              ctrl.$setValidity('minlength', false);
              return viewValue;
            }
          } else {
            ctrl.$setValidity('minlength', false);
            return viewValue;
          }
        })
      }
    };
  });*/

});

app.controller("LoginController", function (CsrfToken, $scope, $http, $window, SweetAlert) {
  $scope.loginForm = {};
  $scope.isProcessing = false;
  $scope.processForm = function (reload) {
    if (reload) {
      $("#preloader").show();
    }
    if (!$scope.isProcessing) {
      $scope.isProcessing = true;
      var url = "/api/player/Login";

      CsrfToken.HttpRequest('POST',url,$scope.loginForm).success(function (data) {
        if (data.result == 1) {
          $window.location.href = "/#/";
          $window.location.reload();
        } else if (data.result == 213) {
          if (bowser.msie && bowser.version <= 8) {
            alert(data.message);
          } else {
            SweetAlert.swal(data.message, "승인을 기다려주시거나 지금채팅하기를 통해 고객지원팀에 문의 하여 주시기 바랍니다", "error");
          }
        } else if (data.result == 203) {
          if (bowser.msie && bowser.version <= 8) {
            alert(data.message);
          } else {
            SweetAlert.swal(data.message, "", "error");
          }
        } else {
          if (bowser.msie && bowser.version <= 8) {
            alert(data.message);
          } else {
            if(data.csrf){
              swal({
                title: "캐시 및 쿠키 삭제 후",
                text: "브라우저를 새로고침해 주세요",
                className: "csrf-swal",
                icon: "error",
                showCancelButton: false,
                confirmButtonClass: "#7cd1f9",
                confirmButtonText: "OK",
                closeOnConfirm: false
              }).then(function(confirm){
                if (confirm) {
                  $window.location.href = "/#/";
                  $window.location.reload();
                }
              });
            } else {
              SweetAlert.swal(data.message, "다시 시도해보세요", "error");
            }
          }
        }
      }).error(function (data, status) {
        console.error('Repos error', status, data);
      })["finally"](function () {
        $scope.isProcessing = false;
        $("#preloader").hide();
      });
    }
  };
});

app.controller("LogoutController", function ($scope, $rootScope, $http, $window, SweetAlert, loggedInStatus, $timeout) {
  $scope.isProcessing = false;
  $rootScope.logout = function () {
    $scope.isProcessing = true;
    $http.get("/api/player/Logout")
      .success(function (data) {
        if (data.result == 1) {
          if (bowser.msie && bowser.version <= 8) {
            alert(data.message);
          } else {
            SweetAlert.swal("로그아웃 되었습니다", "", "success");
          }
          /*DELAY RELOAD AFTER LOGGING OUT*/
          $timeout(function () {
            loggedInStatus.setLoggedOutStatus();
            $window.location.href = "/#/";
            $window.location.reload();
          }, 1000)
        } else {
          if (data.alert) {
            if (bowser.msie && bowser.version <= 8) {
              alert(data.message);
            } else {
              SweetAlert.swal(data.message, "다시 시도해보세요", "error");
            }
          }
        }
      }).error(function (data, result) {
      console.error('Repos error', result, data);
    })["finally"](function () {
      $scope.isProcessing = false;
    });
  }
});

app.controller('NoticeController', function ($rootScope, $scope, $cookies, $http, $window, SweetAlert, $translate) {
  $rootScope.writeQuestion = {};

  $scope.notToday = function () {
    var expireDate = new Date();
    expireDate.setDate(expireDate.getDate() + 1);
    $cookies.put('notToday', 'true', {'expires': expireDate});
    $scope.closeThisDialog();
  };

  $rootScope.processForm = function () {
    $rootScope.isProcessing = true;
    var url = "/api/operation/GetWriteBoard";
    $http({
      method: 'POST',
      url: url,
      data: $.param($rootScope.writeQuestion), // pass in data as strings
      headers: {
        'Content-Type': 'application/x-www-form-urlencoded'
      } // set the headers so angular passing info as form data (not request payload)
    }).success(function (data) {
      if (data.result == 1) {
        if (bowser.msie && bowser.version <= 8) {
          alert(data.message);
        } else {
          $translate([data.message]).then(function (translations) {
            SweetAlert.swal(translations[data.message], "", "success");
          });
        }
      } else {
        if (data.alert) {
          if (bowser.msie && bowser.version <= 8) {
            alert(data.message);
          } else {
            $translate([data.message, "PleaseTryAgain"]).then(function (translations) {
              SweetAlert.swal(translations.PleaseTryAgain, translations[data.message], "success");
            });
          }
        }
      }
    }).error(function (data, result) {
      console.error('Repos error', result, data);
    })["finally"](function () {
      $rootScope.isProcessing = false;
    });
  }
});

app.controller('CashNoticeController', function ($rootScope, $scope, $cookies, $http, $window, SweetAlert, $translate) {
  $scope.notToday = function (index) {
    var expireDate = new Date();
    expireDate.setDate(expireDate.getDate() + 1);
    $cookies.put('notToday-'+index, 'true', {'expires': expireDate});
    $scope.closeThisDialog();
  };
});

app.controller('MovieController', function ($rootScope, $scope, $http,$cookies) {
  $scope.notToday = function () {
    var expireDate = new Date();
    expireDate.setDate(expireDate.getDate() + 1);
    $cookies.put('notToday-New', 'true', {'expires': expireDate});
    $scope.closeThisDialog();
  };
});

app.controller('PharaohNewNoticePopup14', function ($scope, $cookies){
  $scope.notTodayNewPharaoh14= function () {
    var expireDate = new Date();
    expireDate.setDate(expireDate.getDate() + 1);
    $cookies.put('notTodayNewPharaoh-new14', 'true', {'expires': expireDate});
    $scope.closeThisDialog();
  };
});
