app.factory('CsrfToken', function ($rootScope, $http) {
  var token;
  var service = {
    set: set,
    get: get,
    HttpRequest: HttpRequest,
    GetReatltimeTransaction: GetReatltimeTransaction,
    GetEventList: GetEventList,
    GetNoticeList: GetNoticeList,
    CheckServer: CheckServer
  }

  function set() {
    $http.get("/api/system/csrf.php").then(function (data) {
      token = data.data.token;
      $rootScope.$broadcast('csrfToken:setSuccess');
    });
  }

  function get() {
    return token
  }

  function HttpRequest(type, url, param) {
    if (param == "" || !param) {
      param = [];
    }

    if(!type) {
      type = 'GET'
    }

    return $http({
      method: type,
      url: url,
      data: $.param(param),
      headers: {
        'Content-Type': 'application/x-www-form-urlencoded',
        eg_csrf_token_label: get()
      }
    })
  }

  function GetReatltimeTransaction() {
    var url = "/api/finance/DisplayTransaction?count=20";
    HttpRequest('GET', url)
      .success(function (data) {
        if(data.csrf){
          swal({
            title: "캐시 및 쿠키 삭제 후",
            text: "브라우저를 새로고침해 주세요",
            className: "csrf-swal",
            icon: "error",
            showCancelButton: false,
            confirmButtonClass: "#7cd1f9",
            confirmButtonText: "OK",
            closeOnConfirm: false
          })
        }
        else {
          $rootScope.realTimeTransactionList = data;
        }
      }).error(function (data, result) {

    })["finally"](function () {
    });
  }

  function CheckServer() {
    var url = "/api/system/CheckServer?type=return";
    HttpRequest('GET', url)
      .success(function (data) {
        $rootScope.bankContactNumber = data.bank;
        $rootScope.techContactNumber = data.tech;
        $rootScope.emailContact = data.email;
        $rootScope.messengerContact1 = data.messenger1;
        $rootScope.messengerContact2 = data.messenger2;
        $rootScope.WithdrawBankTimeLimitStatus = data.WithdrawBankTimeLimit;
        $rootScope.server_time = data.server_time;
        $rootScope.aff_url = data.aff_url;
        $rootScope.NewMember = data.NewMember;
      }).error(function (data, status) {
      console.error('Repos error', status, data);
    });
  }

  function GetEventList() {
    var url = "/api/operation/GetBoardDetail?type=3";
    HttpRequest("GET", url)
      .success(function (data) {
        if(data.csrf){
          swal({
            title: "캐시 및 쿠키 삭제 후",
            text: "브라우저를 새로고침해 주세요",
            className: "csrf-swal",
            icon: "error",
            showCancelButton: false,
            confirmButtonClass: "#7cd1f9",
            confirmButtonText: "OK",
            closeOnConfirm: false
          })
        }
        else {
          $rootScope.eventList = data.list;
        }
      }).error(function (data, result) {
      console.error('Repos error', result, data);
    })["finally"](function () {
    });
  }

  function GetNoticeList() {
    var url = "/api/operation/GetBoardDetail?type=1&page=1";
    HttpRequest("GET", url)
      .success(function (data) {
        if(data.csrf){
          swal({
            title: "캐시 및 쿠키 삭제 후",
            text: "브라우저를 새로고침해 주세요",
            className: "csrf-swal",
            icon: "error",
            showCancelButton: false,
            confirmButtonClass: "#7cd1f9",
            confirmButtonText: "OK",
            closeOnConfirm: false
          })
        }
        else {
          $rootScope.announceList = data.list;
          $rootScope.displayNoticeToday();
        }
      }).error(function (data, result) {
      console.error('Repos error', result, data);
    })["finally"](function () {
    });
  }

  return service
});

app.run(function (CsrfToken, $rootScope) {
  CsrfToken.set();

  $rootScope.$on('csrfToken:setSuccess', function () {
    CsrfToken.GetReatltimeTransaction();
    CsrfToken.GetEventList();
    CsrfToken.GetNoticeList();
    CsrfToken.CheckServer();
  });
});
