<?php
//환경설정 부분
$sql_site = "SELECT * FROM conf_site order by conf_id asc";
$result_site = mysqli_query($connORA,$sql_site);
$a=1;
while($row_site = mysqli_fetch_array($result_site)){
	//if($a==9)$a++;
	$site_list[$a]=$row_site;
	$a++;
}

//print_r($site_list);
$soul_ag_info = explode("#", $site_list[62]['conf_content']);

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////골드 V2
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//에이젼시 머니
function gd_agentMoney(){

	global $site_list;
	$gs_ag_info = explode("#", $site_list[66]['conf_content']);

	$data = array(
		"agent_code"=>$gs_ag_info['1'],
		"agent_token"=>$gs_ag_info['2']
	);

	$ch=curl_init();
	curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $gs_ag_info['0']."/v2/info");
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_HEADER, false);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Content-Type: application/json'
	));
	curl_setopt($ch, CURLOPT_VERBOSE, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	$response = curl_exec($ch);
	curl_close($ch);

	$res = json_decode($response, true);

	$res_chg['status'] = $res['status'];
	$res_chg['msg'] = $res['msg'];
	$res_chg_agent['agent_code'] = $res['agent_code'];
	$res_chg_agent['balance'] = $res['agent_balance'];
	$res_chg['agent'] = $res_chg_agent;

	return json_encode($res_chg);

	//return $response;
	//{"status":1,"msg":"SUCCESS","agent_code":"tiger","agent_balance":73465065,"agent_type":"Transfer","agent_total_debit":0,"agent_total_credit":0,"agent_target_rtp":99,"agent_real_rtp":0,"agent_created_at":"2023-07-12T06:06:16.000Z","user_list":
	////{"status":1,"msg":"SUCCESS","agent":{"agent_code":"tiger","balance":55547485}}
}

//사용자 생성
function gd_userCreate($user_id){

	global $site_list;
	$gs_ag_info = explode("#", $site_list[66]['conf_content']);

	$data = array(
		"agent_code"=>$gs_ag_info['1'],
		"agent_token"=>$gs_ag_info['2'],
		"user_code"=>$user_id
	);

	$ch=curl_init();
	curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $gs_ag_info['0']."/v2/user_create");
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_HEADER, false);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Content-Type: application/json'
	));
	curl_setopt($ch, CURLOPT_VERBOSE, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	$response = curl_exec($ch);
	curl_close($ch);

	return $response;
	//{"status":1,"msg":"SUCCESS","agent_code":"tiger","agent_balance":73465065,"agent_type":"Transfer","user_code":"per78_test001","user_balance":0,"user_created":true,"user_deposit":false}
}

//사용자 보유머니
function gd_userMoney($user_id){
	global $site_list;
	$gs_ag_info = explode("#", $site_list[66]['conf_content']);

	$data = array(
		"agent_code"=>$gs_ag_info['1'],
		"agent_token"=>$gs_ag_info['2'],
		"user_code"=>$user_id
	);

	$ch=curl_init();
	curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $gs_ag_info['0']."/v2/info");
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_HEADER, false);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Content-Type: application/json'
	));
	curl_setopt($ch, CURLOPT_VERBOSE, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	$response = curl_exec($ch);
	curl_close($ch);

	$res = json_decode($response, true);

	$res_chg['status'] = $res['status'];
	$res_chg['msg'] = $res['msg'];
	$res_chg_agent['agent_code'] = $res['agent_code'];
	$res_chg_agent['balance'] = $res['agent_balance'];
	$res_chg_user['user_code'] = $res['user_list'][0]['user_code'];
	$res_chg_user['balance'] = $res['user_list'][0]['balance'];
	$res_chg['agent'] = $res_chg_agent;
	$res_chg['user'] = $res_chg_user;

	return json_encode($res_chg);

	//return $response;
	//{"status":1,"msg":"SUCCESS","agent_code":"tiger","agent_balance":73465065,"agent_type":"Transfer","agent_total_debit":0,"agent_total_credit":0,"agent_target_rtp":99,"agent_real_rtp":0,"agent_created_at":"2023-07-12T06:06:16.000Z","user_list":[{"user_code":"per78_test001","balance":0,"user_balance":0,"user_total_debit":0,"user_total_credit":0,"user_target_rtp":99,"user_real_rtp":0,"user_created_at":"2023-09-18T07:52:36.000Z"}]}
	//{"status":1,"msg":"SUCCESS","agent":{"agent_code":"tiger","balance":55547485},"user":{"user_code":"per78_test002","balance":0}}
}

//머니충전
function gd_moneyDeposit($user_id, $money){
	global $site_list;
	$gs_ag_info = explode("#", $site_list[66]['conf_content']);

	$data = array(
		"agent_code"=>$gs_ag_info['1'],
		"agent_token"=>$gs_ag_info['2'],
		"user_code"=>$user_id,
		"amount"=>$money
	);

	$ch=curl_init();
	curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $gs_ag_info['0']."/v2/user_deposit");
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_HEADER, false);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Content-Type: application/json'
	));
	curl_setopt($ch, CURLOPT_VERBOSE, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	$response = curl_exec($ch);
	curl_close($ch);

	return $response;
	//{"status":1,"msg":"SUCCESS","agent_balance":73464065,"user_balance":1000}
}

//머니환전
function gd_moneyWithdraw($user_id){
	global $site_list;
	$gs_ag_info = explode("#", $site_list[66]['conf_content']);

	$data = array(
		"agent_code"=>$gs_ag_info['1'],
		"agent_token"=>$gs_ag_info['2'],
		"user_code"=>$user_id
	);

	$ch=curl_init();
	curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $gs_ag_info['0']."/v2/user_withdraw");
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_HEADER, false);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Content-Type: application/json'
	));
	curl_setopt($ch, CURLOPT_VERBOSE, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	$response = curl_exec($ch);
	curl_close($ch);

	$res = json_decode($response, true);

	$res_chg['status'] = $res['status'];
	$res_chg['msg'] = $res['msg'];
	$res_chg_agent['agent_code'] = $res['agent_code'];
	$res_chg_agent['balance'] = $res['agent_balance'];
	$res_chg_user['user_code'] = $res['user_code'];
	$res_chg_user['withdraw_amount'] = $res['withdraw_amount'];
	$res_chg_user['balance'] = $res['user_balance'];
	$res_chg['agent'] = $res_chg_agent;
	$res_chg['user'] = $res_chg_user;

	return json_encode($res_chg);

	//return $response;
	//{"status":1,"msg":"SUCCESS","agent_code":"tiger","agent_balance":73465065,"agent_type":"Transfer","user_code":"per78_test001","user_balance":0,"withdraw_amount":1000}
	//{"status":1,"msg":"SUCCESS","agent":{"agent_code":"tiger","balance":55547485},"user":{"user_code":"per78_test002","withdraw_amount":1000,"balance":0}}
}

//게임URL
function gd_gameLink($user_id, $game_type, $prd_id, $game_id){
	global $site_list;
	$gs_ag_info = explode("#", $site_list[66]['conf_content']);

	$data = array(
		"agent_code"=>$gs_ag_info['1'],
		"agent_token"=>$gs_ag_info['2'],
		"user_code"=>$user_id,
		"game_type"=>$game_type,
		"provider_code"=>$prd_id,
		"game_code"=>$game_id,
		"lang"=>"ko"
	);

	$ch=curl_init();
	curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $gs_ag_info['0']."/v2/game_launch");
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_HEADER, false);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Content-Type: application/json'
	));
	curl_setopt($ch, CURLOPT_VERBOSE, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	$response = curl_exec($ch);
	curl_close($ch);

	return $response;
}

//게임사 리스트
function gd_ThirdPartyList($game_type){
	global $site_list;
	$gs_ag_info = explode("#", $site_list[66]['conf_content']);

	$data = array(
		"agent_code"=>$gs_ag_info['1'],
		"agent_token"=>$gs_ag_info['2'],
		"game_type"=>$game_type
	);

	$ch=curl_init();
	curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $gs_ag_info['0']."/v2/provider_list");
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_HEADER, false);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Content-Type: application/json'
	));
	curl_setopt($ch, CURLOPT_VERBOSE, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	$response = curl_exec($ch);
	curl_close($ch);

	return $response;
}

//게임 리스트
function gd_gameList($prd_id){
	global $site_list;
	$gs_ag_info = explode("#", $site_list[66]['conf_content']);

	$data = array(
		"agent_code"=>$gs_ag_info['1'],
		"agent_token"=>$gs_ag_info['2'],
		"provider_code"=>$prd_id,
		"game_type"=>"slot"
	);

	$ch=curl_init();
	curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $gs_ag_info['0']."/v2/game_list");
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_HEADER, false);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Content-Type: application/json'
	));
	curl_setopt($ch, CURLOPT_VERBOSE, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	$response = curl_exec($ch);
	curl_close($ch);

	return $response;
}

//배팅내역
function gd_game_log($conf_idx){
	global $site_list;
	$gs_ag_info = explode("#", $site_list[66]['conf_content']);

	$data = array(
		"agent_code"=>$ag_info['1'],
		"agent_token"=>$ag_info['2'],
		"game_type"=>"slot",
		"start"=>$api_start,
		"end"=>date("Y-m-d H:i:s"),
		"page"=>0,
		"length"=>1000,
		"search"=>""
	);

	$ch=curl_init();
	curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $ag_info['0']."/v2/get_date_log");
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_HEADER, false);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Content-Type: application/json'
	));
	curl_setopt($ch, CURLOPT_VERBOSE, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	$response = curl_exec($ch);
	curl_close($ch);

	return $response;
}



////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////골드카지노
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//에이젼시 머니
function gdc_agentMoney(){

	global $site_list;
	$gs_ag_info = explode("#", $site_list[67]['conf_content']);

	$data = array(
		"method"=>"money_info",
		"agent_code"=>$gs_ag_info['1'],
		"agent_token"=>$gs_ag_info['2']
	);

	$ch=curl_init();
	curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $gs_ag_info['0']);
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_HEADER, false);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Content-Type: application/json'
	));
	curl_setopt($ch, CURLOPT_VERBOSE, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	$response = curl_exec($ch);
	curl_close($ch);

	//agent_balance => balance로 변경
	$response = str_replace("agent_balance", "balance", $response); 

	return $response;
}

//사용자 생성
function gdc_userCreate($user_id){

	global $site_list;
	$gs_ag_info = explode("#", $site_list[67]['conf_content']);

	$data = array(
		"method"=>"user_create",
		"agent_code"=>$gs_ag_info['1'],
		"agent_token"=>$gs_ag_info['2'],
		"user_code"=>$user_id
	);

	$ch=curl_init();
	curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $gs_ag_info['0']);
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_HEADER, false);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Content-Type: application/json'
	));
	curl_setopt($ch, CURLOPT_VERBOSE, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	$response = curl_exec($ch);
	curl_close($ch);

	return $response;
}

//사용자 보유머니
function gdc_userMoney($user_id){
	global $site_list;
	$gs_ag_info = explode("#", $site_list[67]['conf_content']);

	$data = array(
		"method"=>"money_info",
		"agent_code"=>$gs_ag_info['1'],
		"agent_token"=>$gs_ag_info['2'],
		"user_code"=>$user_id
	);

	$ch=curl_init();
	curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $gs_ag_info['0']);
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_HEADER, false);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Content-Type: application/json'
	));
	curl_setopt($ch, CURLOPT_VERBOSE, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	$response = curl_exec($ch);
	curl_close($ch);

	//user_balance => balance로 변경
	$response = str_replace("user_balance", "balance", $response); 

	return $response;
}

//머니충전
function gdc_moneyDeposit($user_id, $money){
	global $site_list;
	$gs_ag_info = explode("#", $site_list[67]['conf_content']);

	$data = array(
		"method"=>"user_deposit",
		"agent_code"=>$gs_ag_info['1'],
		"agent_token"=>$gs_ag_info['2'],
		"user_code"=>$user_id,
		"amount"=>$money
	);

	$ch=curl_init();
	curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $gs_ag_info['0']);
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_HEADER, false);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Content-Type: application/json'
	));
	curl_setopt($ch, CURLOPT_VERBOSE, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	$response = curl_exec($ch);
	curl_close($ch);

	return $response;
}

//머니환전
function gdc_moneyWithdraw($user_id){
	global $site_list;
	$gs_ag_info = explode("#", $site_list[67]['conf_content']);

	$data = array(
		"method"=>"user_withdraw_reset",
		"agent_code"=>$gs_ag_info['1'],
		"agent_token"=>$gs_ag_info['2'],
		"user_code"=>$user_id
	);

	$ch=curl_init();
	curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $gs_ag_info['0']);
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_HEADER, false);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Content-Type: application/json'
	));
	curl_setopt($ch, CURLOPT_VERBOSE, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	$response = curl_exec($ch);
	curl_close($ch);

	return $response;
}

//게임URL
function gdc_gameLink($user_id, $prd_id){
	global $site_list;
	$gs_ag_info = explode("#", $site_list[67]['conf_content']);

	$data = array(
		"method"=>"game_launch",
		"agent_code"=>$gs_ag_info['1'],
		"agent_token"=>$gs_ag_info['2'],
		"user_code"=>$user_id,
		"provider_code"=>$prd_id,
		"lang"=>"ko"
	);

	$ch=curl_init();
	curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $gs_ag_info['0']);
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_HEADER, false);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Content-Type: application/json'
	));
	curl_setopt($ch, CURLOPT_VERBOSE, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	$response = curl_exec($ch);
	curl_close($ch);

	return $response;
}

//게임사 리스트
function gdc_ThirdPartyList($game_type){
	global $site_list;
	$gs_ag_info = explode("#", $site_list[67]['conf_content']);

	$data = array(
		"method"=>"provider_list",
		"agent_code"=>$gs_ag_info['1'],
		"agent_token"=>$gs_ag_info['2'],
		"game_type"=>$game_type
	);

	$ch=curl_init();
	curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $gs_ag_info['0']);
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_HEADER, false);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Content-Type: application/json'
	));
	curl_setopt($ch, CURLOPT_VERBOSE, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	$response = curl_exec($ch);
	curl_close($ch);

	return $response;
}

//게임 리스트
function gdc_gameList($prd_id){
	global $site_list;
	$gs_ag_info = explode("#", $site_list[67]['conf_content']);

	$data = array(
		"method"=>"game_list",
		"agent_code"=>$gs_ag_info['1'],
		"agent_token"=>$gs_ag_info['2'],
		"provider_code"=>$prd_id,
		"game_type"=>"slot"
	);

	$ch=curl_init();
	curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $gs_ag_info['0']);
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_HEADER, false);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Content-Type: application/json'
	));
	curl_setopt($ch, CURLOPT_VERBOSE, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	$response = curl_exec($ch);
	curl_close($ch);

	return $response;
}

//배팅내역
function gdc_game_log($conf_idx){
	global $site_list;
	$gs_ag_info = explode("#", $site_list[67]['conf_content']);

	$data = array(
		"method"=>"transaction_list",
		"agent_code"=>$gs_ag_info['1'],
		"agent_token"=>$gs_ag_info['2'],
		"provider_code"=>"EVOLUTION",
		"start_data"=>$conf_idx,
		"end_data"=>date("Y-m-d H:i:s"),
		"page_number"=>0,
		"perPage_count"=>1000
	);

	$ch=curl_init();
	curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $gs_ag_info['0']);
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_HEADER, false);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Content-Type: application/json'
	));
	curl_setopt($ch, CURLOPT_VERBOSE, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	$response = curl_exec($ch);
	curl_close($ch);

	return $response;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////슬롯시티
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//에이젼시 머니
function sc_agentMoney(){

	global $site_list;
	$ag_info = explode("#", $site_list[64]['conf_content']);

	$data = array(
		//"user_id"=>$ag_id
	);

	$ch=curl_init();
	curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $ag_info['0']."/v4/agent/info");
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_HEADER, false);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Authorization: Bearer '.$ag_info['2'],
		'Accept: application/json',
		'Content-Type: application/json'
	));
	curl_setopt($ch, CURLOPT_VERBOSE, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	$response = curl_exec($ch);
	curl_close($ch);

	return $response;
	//{"code":0,"message":"OK","data":{"name":"퍼팩트","point":100000,"win_ratio":80.0}}
}

//사용자생성
function sc_userCreate($user_id){

	global $site_list;
	$ag_info = explode("#", $site_list[64]['conf_content']);

	$data = array(
		"name"=>$user_id
	);

	$ch=curl_init();
	curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $ag_info['0']."/v4/user/create");
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_HEADER, false);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Authorization: Bearer '.$ag_info['2'],
		'Accept: application/json',
		'Content-Type: application/json'
	));
	curl_setopt($ch, CURLOPT_VERBOSE, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	$response = curl_exec($ch);
	curl_close($ch);

	return $response;
	//{"code":0,"message":"OK","data":{"user_code":400018521}}
}

//사용자 정보 확인 (user_code: 사용자 생성때 발급 받음)
function sc_userMoney($user_code){

	global $site_list;
	$ag_info = explode("#", $site_list[64]['conf_content']);

	$data = array(
		"user_code"=>$user_code
	);

	$ch=curl_init();
	curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $ag_info['0']."/v4/user/info");
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_HEADER, false);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Authorization: Bearer '.$ag_info['2'],
		'Accept: application/json',
		'Content-Type: application/json'
	));
	curl_setopt($ch, CURLOPT_VERBOSE, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	$response = curl_exec($ch);
	curl_close($ch);

	return $response;
	//{"code":0,"message":"OK","data":{"name":"test001","balance":0.0}}
}

//사용자 머니 지급
function sc_moneyDeposit($user_code, $amount){

	global $site_list;
	$ag_info = explode("#", $site_list[64]['conf_content']);

	$data = array(
		"user_code"=>$user_code,
		"amount"=>$amount
	);

	$ch=curl_init();
	curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $ag_info['0']."/v4/wallet/deposit");
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_HEADER, false);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Authorization: Bearer '.$ag_info['2'],
		'Accept: application/json',
		'Content-Type: application/json'
	));
	curl_setopt($ch, CURLOPT_VERBOSE, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	$response = curl_exec($ch);
	curl_close($ch);

	return $response;
	//{"code":0,"message":"OK","data":{"balance":1000.0,"amount":1000}}
}

function sc_moneyWithdraw($user_code){
	global $site_list;
	$ag_info = explode("#", $site_list[64]['conf_content']);

	$data = array(
		"user_code"=>$user_code
	);

	$ch=curl_init();
	curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $ag_info['0']."/v4/wallet/withdraw-all");
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_HEADER, false);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Authorization: Bearer '.$ag_info['2'],
		'Accept: application/json',
		'Content-Type: application/json'
	));
	curl_setopt($ch, CURLOPT_VERBOSE, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	$response = curl_exec($ch);
	curl_close($ch);

	return $response;
	//{"code":0,"message":"OK","data":{"balance":0.0,"amount":1000}}
}

//게임사 리스트
function sc_ThirdPartyList(){
	global $site_list;
	$ag_info = explode("#", $site_list[64]['conf_content']);

	$data = array(
		"lang"=>"2"
	);

	$ch=curl_init();
	curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $ag_info['0']."/v4/game/providers");
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_HEADER, false);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Authorization: Bearer '.$ag_info['2'],
		'Accept: application/json',
		'Content-Type: application/json'
	));
	curl_setopt($ch, CURLOPT_VERBOSE, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	$response = curl_exec($ch);
	curl_close($ch);

	return $response;
}

//게임 리스트
function sc_gameList($prd_id){
	global $site_list;
	$ag_info = explode("#", $site_list[64]['conf_content']);

	$data = array(
		"provider_id"=>$prd_id,
		"lang"=>"2"
	);

	$ch=curl_init();
	curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $ag_info['0']."/v4/game/games");
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_HEADER, false);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Authorization: Bearer '.$ag_info['2'],
		'Accept: application/json',
		'Content-Type: application/json'
	));
	curl_setopt($ch, CURLOPT_VERBOSE, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	$response = curl_exec($ch);
	curl_close($ch);

	return $response;
}

//게임URL
function sc_gameLink($user_code, $prd_id, $game_id){
	global $site_list;
	$ag_info = explode("#", $site_list[64]['conf_content']);

	$data = array(
		"user_code"=>$user_code,
		"provider_id"=>$prd_id,
		"game_symbol"=>$game_id,
		"lang"=>"2"
	);

	$ch=curl_init();
	curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $ag_info['0']."/v4/game/game-url");
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_HEADER, false);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Authorization: Bearer '.$ag_info['2'],
		'Accept: application/json',
		'Content-Type: application/json'
	));
	curl_setopt($ch, CURLOPT_VERBOSE, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	$response = curl_exec($ch);
	curl_close($ch);

	return $response;
}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////몬스터애볼
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//에이젼트 머니
function mse_agentMoney(){
	global $site_list;
	$ag_info = explode("#", $site_list[65]['conf_content']);

	$command="balance";
	$request_timestamp=date("Y-m-d H:i:s");
	$secretkey=$ag_info['2'];
	$hash = sha1($command . $request_timestamp . $secretkey);

	$data = array(
		"command"=>$command,
		"data"=> array(
			"OperatorId"=> $ag_info['1'],
			"Player"=> $ag_info['1']
		),
		"request_timestamp"=>$request_timestamp,
		"hash"=>$hash
	);
	

	$ch=curl_init();
	curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $ag_info['0']."/".$command);
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_HEADER, false);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Content-Type: application/json'
	));
	curl_setopt($ch, CURLOPT_VERBOSE, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	$response = curl_exec($ch);
	curl_close($ch);

	return $response;
}

//사용자생성
function mse_userCreate($user_id,$user_pw,$user_nickname,$user_name){

	global $site_list;
	$ag_info = explode("#", $site_list[65]['conf_content']);

	$command="register";
	$request_timestamp=date("Y-m-d H:i:s");
	$secretkey=$ag_info['2'];
	$hash = sha1($command . $request_timestamp . $secretkey);

	$data = array(
		"command"=>$command,
		"data"=> array(
			"OperatorId"=> $ag_info['1'],
			"UserName"=> $user_id,
			"Password"=> $user_pw,
			"Nickname"=> $user_nickname,
			"Fullname"=> $user_name, 
		),
		"request_timestamp"=>$request_timestamp,
		"hash"=>$hash
	);

	$ch=curl_init();
	curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $ag_info['0']."/".$command);
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_HEADER, false);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Content-Type: application/json'
	));
	curl_setopt($ch, CURLOPT_VERBOSE, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	$response = curl_exec($ch);
	curl_close($ch);

	return $response;
}

//사용자 정보 확인
function mse_userMoney($user_id){

	global $site_list;
	$ag_info = explode("#", $site_list[65]['conf_content']);

	$command="balance";
	$request_timestamp=date("Y-m-d H:i:s");
	$secretkey=$ag_info['2'];
	$hash = sha1($command . $request_timestamp . $secretkey);

	$data = array(
		"command"=>$command,
		"data"=> array(
			"OperatorId"=> $ag_info['1'],
			"Player"=> $user_id
		),
		"request_timestamp"=>$request_timestamp,
		"hash"=>$hash
	);
	

	$ch=curl_init();
	curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $ag_info['0']."/".$command);
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_HEADER, false);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Content-Type: application/json'
	));
	curl_setopt($ch, CURLOPT_VERBOSE, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	$response = curl_exec($ch);
	curl_close($ch);

	return $response;
}

//사용자 머니 지급
function mse_moneyDeposit($user_id, $amount){

	global $site_list;
	$ag_info = explode("#", $site_list[65]['conf_content']);

	$command="deposit";
	$request_timestamp=date("Y-m-d H:i:s");
	$secretkey=$ag_info['2'];
	$hash = sha1($command . $request_timestamp . $secretkey);
	$data = array(
		"command"=>$command,
		"data"=> array(
			"OperatorId"=> $ag_info['1'],
			"Player"=> $user_id,
			"Amount"=> $amount  
		),
		"request_timestamp"=>$request_timestamp,
		"hash"=>$hash
	);

	//print_r($data);

	$ch=curl_init();
	curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $ag_info['0']."/".$command);
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_HEADER, false);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Content-Type: application/json'
	));
	curl_setopt($ch, CURLOPT_VERBOSE, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 1);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	$response = curl_exec($ch);
	curl_close($ch);

	return $response;
}

function mse_moneyWithdraw($user_id, $amount){
	global $site_list;
	$ag_info = explode("#", $site_list[65]['conf_content']);

	$command="withdrawal";
	$request_timestamp=date("Y-m-d H:i:s");
	$secretkey=$ag_info['2'];
	$hash = sha1($command . $request_timestamp . $secretkey);
	$data = array(
		"command"=>$command,
		"data"=> array(
			"OperatorId"=> $ag_info['1'],
			"Player"=> $user_id,
			"Amount"=> $amount  
		),
		"request_timestamp"=>$request_timestamp,
		"hash"=>$hash
	);

	$ch=curl_init();
	curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $ag_info['0']."/".$command);
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_HEADER, false);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Content-Type: application/json'
	));
	curl_setopt($ch, CURLOPT_VERBOSE, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	$response = curl_exec($ch);
	curl_close($ch);

	return $response;
}

//게임 리스트
function mse_gameList($prd_id){
	global $site_list;
	$ag_info = explode("#", $site_list[65]['conf_content']);

	$command="gamelist";
	$request_timestamp=date("Y-m-d H:i:s");
	$secretkey=$ag_info['2'];
	$hash = sha1($command . $request_timestamp . $secretkey);
	$data = array(
		"command"=>$command,
		"data"=> array(
			"OperatorId"=> $ag_info['1'],
			"Provider"=> $prd_id
		),
		"request_timestamp"=>$request_timestamp,
		"hash"=>$hash
	);

	$ch=curl_init();
	curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $ag_info['0']."/game-list");
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_HEADER, false);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Content-Type: application/json'
	));
	curl_setopt($ch, CURLOPT_VERBOSE, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	$response = curl_exec($ch);
	curl_close($ch);

	return $response;
}

//게임URL
function mse_gameLink($user_id, $token_info, $game_id){
	global $site_list;
	$ag_info = explode("#", $site_list[65]['conf_content']);

	//$launch_url = 'https://api.eslotsapi.com/GsoftA/GamePlay.php';
	$launch_url = 'https://api.eslotsapi.com/GsoftXA/GamePlay.php';
	$command = 'play';
	$secretkey=$ag_info['2'];
	$hash = sha1($command . $secretkey . $user_id);
	$openurl = $launch_url.'?Partner='.$ag_info['1'].'&command=play&Player='.$user_id.'&game_id='.$game_id.'&hash='.$hash.'&token='.$token_info;

	return $openurl;
}

//배팅내역
function mse_bet_list(){
	global $site_list;
	$ag_info = explode("#", $site_list[65]['conf_content']);

	$created_at = date("Y-m-d H:i:s");
	$timestamp = strtotime($created_at." -9 hours");
	$end_time = date("Y-m-d H:i:s", $timestamp);

	$command="bet_records";
	$request_timestamp=date("Y-m-d H:i:s");
	$secretkey=$ag_info['2'];
	$hash = sha1($command . $request_timestamp . $secretkey);
	$data = array(
		"command"=>$command,
		"data"=> array(
			"OperatorId"=> $ag_info['1'],
			"provider"=> "CasinoB",
			"startTime"=> $site_list[65]['conf_idx'],
			"endTime"=> $end_time,
			"pageSize"=> 1000,
			"lastId"=> ""
		),
		"request_timestamp"=>$request_timestamp,
		"hash"=>$hash
	);

	$ch=curl_init();
	curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $ag_info['0']."/bet_records");
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_HEADER, false);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Content-Type: application/json'
	));
	curl_setopt($ch, CURLOPT_VERBOSE, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	$response = curl_exec($ch);
	curl_close($ch);

	return $response;
}

//win내역
function mse_win_list(){
	global $site_list;
	$ag_info = explode("#", $site_list[65]['conf_content']);

	$created_at = date("Y-m-d H:i");
	$timestamp = strtotime($created_at." -9 hours");
	$end_time = date("Y-m-d H:i", $timestamp);

	$command="win_records";
	$request_timestamp=date("Y-m-d H:i:s");
	$secretkey=$ag_info['2'];
	$hash = sha1($command . $request_timestamp . $secretkey);
	$data = array(
		"command"=>$command,
		"data"=> array(
			"OperatorId"=> $ag_info['1'],
			"provider"=> "CasinoB",
			"startTime"=> $site_list[65]['conf_idx'],
			"endTime"=> $end_time,
			"pageSize"=> 1000,
			"lastId"=> ""
		),
		"request_timestamp"=>$request_timestamp,
		"hash"=>$hash
	);

	$ch=curl_init();
	curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $ag_info['0']."/win_records");
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_HEADER, false);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Content-Type: application/json'
	));
	curl_setopt($ch, CURLOPT_VERBOSE, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	$response = curl_exec($ch);
	curl_close($ch);

	return $response;
}


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////sta
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function sta_agentMoney(){
	global $site_list;
	$ag_info = explode("#", $site_list[71]['conf_content']);

	$data = array(
		"method"=>"GetAgentInfo",
		"token"=>$ag_info['2'],
		"agentCode"=>$ag_info['1']
	);

	$ch=curl_init();
	curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $ag_info['0']);
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Content-Type: application/json',
	));
	curl_setopt($ch, CURLOPT_VERBOSE, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	$response = curl_exec($ch);
	curl_close($ch);

	return $response;
	//{"balance":0.00,"status":0,"msg":"Success"}
}

//사용자 보유머니
function sta_userMoney($user_id){
	global $site_list;
	$ag_info = explode("#", $site_list[71]['conf_content']);

	$data = array(
		"method"=>"GetUserInfo",
		"token"=>$ag_info['2'],
		"agentCode"=>$ag_info['1'],
		"userCode"=>$user_id
	);

	$ch=curl_init();
	curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $ag_info['0']);
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Content-Type: application/json',
	));
	curl_setopt($ch, CURLOPT_VERBOSE, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	$response = curl_exec($ch);
	curl_close($ch);

	return $response;
	//{"users":[{"userCode":"test001","balance":0.0}],"status":0,"msg":"Success"}
}

//사용자 생성
function sta_userCreate($user_id){
	global $site_list;
	$ag_info = explode("#", $site_list[71]['conf_content']);

	$data = array(
		"method"=>"CreateUser",
		"token"=>$ag_info['2'],
		"agentCode"=>$ag_info['1'],
		"userCode"=>$user_id
	);

	$ch=curl_init();
	curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $ag_info['0']);
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Content-Type: application/json',
	));
	curl_setopt($ch, CURLOPT_VERBOSE, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	$response = curl_exec($ch);
	curl_close($ch);

	return $response;
	//{"userCode":"test001","status":0,"msg":"Success"}
}

//머니충전
function sta_moneyDeposit($user_id, $user_money){
	global $site_list;
	$ag_info = explode("#", $site_list[71]['conf_content']);

	$data = array(
		"method"=>"Deposit",
		"token"=>$ag_info['2'],
		"agentCode"=>$ag_info['1'],
		"userCode"=>$user_id,
		"amount"=>$user_money
	);

	$ch=curl_init();
	curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $ag_info['0']);
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Content-Type: application/json',
	));
	curl_setopt($ch, CURLOPT_VERBOSE, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	$response = curl_exec($ch);
	curl_close($ch);

	return $response;
	//{"status":8,"msg":"INSUFFICENT_MONEY","description":"에이젠트에 머니가 부족합니다. 에이젠트코드=vvip01,현재머니=0.00,트랜잭션=10000"}
}

//머니환전
function sta_moneyWithdraw($user_id){
	global $site_list;
	$ag_info = explode("#", $site_list[71]['conf_content']);

	$data = array(
		"method"=>"WithdrawAll",
		"token"=>$ag_info['2'],
		"agentCode"=>$ag_info['1'],
		"userCode"=>$user_id
	);

	$ch=curl_init();
	curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $ag_info['0']);
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Content-Type: application/json',
	));
	curl_setopt($ch, CURLOPT_VERBOSE, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	$response = curl_exec($ch);
	curl_close($ch);

	return $response;
	//{"prevBalance":0.0,"balance":0.0,"status":0,"msg":"Success"}
}

//벤더사
function sta_game_vendor(){
	global $site_list;
	$ag_info = explode("#", $site_list[71]['conf_content']);

	$data = array(
		"method"=>"GetVendors",
		"token"=>$ag_info['2'],
		"agentCode"=>$ag_info['1']
	);

	$ch=curl_init();
	curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $ag_info['0']);
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Content-Type: application/json',
	));
	curl_setopt($ch, CURLOPT_VERBOSE, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	$response = curl_exec($ch);
	curl_close($ch);

	return $response;
}

//게임리스트
function sta_game_list($vendor){
	global $site_list;
	$ag_info = explode("#", $site_list[71]['conf_content']);

	$data = array(
		"method"=>"GetVendorGames",
		"token"=>$ag_info['2'],
		"agentCode"=>$ag_info['1'],
		"vendorCode"=>$vendor
	);

	$ch=curl_init();
	curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $ag_info['0']);
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Content-Type: application/json',
	));
	curl_setopt($ch, CURLOPT_VERBOSE, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	$response = curl_exec($ch);
	curl_close($ch);

	return $response;
}

//게임실행
function sta_gameLink($user_id, $user_name, $game_key, $vendor_key){

	global $site_list;
	$ag_info = explode("#", $site_list[71]['conf_content']);

	$data = array(
		"method"=>"GetGameUrl",
		"token"=>$ag_info['2'],
		"agentCode"=>$ag_info['1'],
		"gameCode"=>$game_key,
		"userCode"=>$user_id,
		"nickname"=>$user_name,
		"vendorCode"=>$vendor_key
	);

	$ch=curl_init();
	curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $ag_info['0']);
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Content-Type: application/json',
	));
	curl_setopt($ch, CURLOPT_VERBOSE, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	$response = curl_exec($ch);
	curl_close($ch);

	return $response;
}

function sta_transaction(){

	global $site_list;
	$ag_info = explode("#", $site_list[71]['conf_content']);

	//마지막 idx값
	$conf_idx_array = $site_list[70]['conf_idx'];
	if($conf_idx_array=="")$conf_idx_array="2023-03-20T12:30:00.150000Z";

	$data="vendorKey=&sdate=".$conf_idx_array."&edate=&groupKey=&username=&limit=2000";

	$ch=curl_init();
	curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $ag_info['0']."/transaction");
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'k-username: '.$ag_info['1'],
		'k-secret: '.$ag_info['2'],
		'User-agent: Mozilla',
		'Content-Type: application/x-www-form-urlencoded'
	));
	curl_setopt($ch, CURLOPT_VERBOSE, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
	$response = curl_exec($ch);
	curl_close($ch);

	return $response;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////골드카지노 V2.0
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//에이젼시 머니
function gdc2_agentMoney(){

	global $site_list;
	$gs_ag_info = explode("#", $site_list[75]['conf_content']);

	$data = array(
		"method"=>"GetAgentInfo",
		"agentCode"=>$gs_ag_info[1],
		"token"=>$gs_ag_info[2]
	);

	$ch=curl_init();
	curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $gs_ag_info[0]);
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_HEADER, false);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Content-Type: application/json'
	));
	curl_setopt($ch, CURLOPT_VERBOSE, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	$response = curl_exec($ch);
	curl_close($ch);

	//agent_balance => balance로 변경
	$response = str_replace("agent_balance", "balance", $response); 

	return $response;
	//{"balance":1000000.00,"status":0,"msg":"Success"}
}

//사용자 생성
function gdc2_userCreate($user_id){

	global $site_list;
	$gs_ag_info = explode("#", $site_list[75]['conf_content']);

	$data = array(
		"method"=>"CreateUser",
		"agentCode"=>$gs_ag_info[1],
		"token"=>$gs_ag_info[2],
		"userCode"=>$user_id
	);

	$ch=curl_init();
	curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $gs_ag_info[0]);
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_HEADER, false);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Content-Type: application/json'
	));
	curl_setopt($ch, CURLOPT_VERBOSE, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	$response = curl_exec($ch);
	curl_close($ch);

	return $response;
	//{"userCode":"test001","status":0,"msg":"Success"}
}

//사용자 보유머니
function gdc2_userMoney($user_id){

	global $site_list;
	$gs_ag_info = explode("#", $site_list[75]['conf_content']);

	$data = array(
		"method"=>"GetUserInfo",
		"agentCode"=>$gs_ag_info[1],
		"token"=>$gs_ag_info[2],
		"userCode"=>$user_id
	);

	$ch=curl_init();
	curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $gs_ag_info[0]);
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_HEADER, false);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Content-Type: application/json'
	));
	curl_setopt($ch, CURLOPT_VERBOSE, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	$response = curl_exec($ch);
	curl_close($ch);

	return $response;
	/*
	Array
	(
		[users] => Array
			(
				[0] => Array
					(
						[userCode] => test001
						[balance] => 0
					)

			)

		[status] => 0
		[msg] => Success
	)	
	*/
}

//머니충전
function gdc2_moneyDeposit($user_id, $money){

	global $site_list;
	$gs_ag_info = explode("#", $site_list[75]['conf_content']);

	$data = array(
		"method"=>"Deposit",
		"agentCode"=>$gs_ag_info[1],
		"token"=>$gs_ag_info[2],
		"userCode"=>$user_id,
		"amount"=>$money
	);

	$ch=curl_init();
	curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $gs_ag_info[0]);
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_HEADER, false);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Content-Type: application/json'
	));
	curl_setopt($ch, CURLOPT_VERBOSE, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	$response = curl_exec($ch);
	curl_close($ch);

	return $response;
	//{"prevBalance":0.0,"balance":1000.0,"status":0,"msg":"Success"}
}

//머니환전
function gdc2_moneyWithdraw($user_id){

	global $site_list;
	$gs_ag_info = explode("#", $site_list[75]['conf_content']);

	$data = array(
		"method"=>"WithdrawAll",
		"agentCode"=>$gs_ag_info[1],
		"token"=>$gs_ag_info[2],
		"userCode"=>$user_id
	);

	$ch=curl_init();
	curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $gs_ag_info[0]);
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_HEADER, false);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Content-Type: application/json'
	));
	curl_setopt($ch, CURLOPT_VERBOSE, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	$response = curl_exec($ch);
	curl_close($ch);

	return $response;
	//{"prevBalance":1000.0,"balance":0.0,"status":0,"msg":"Success"}
}

//게임URL
function gdc2_gameLink($user_id, $vendorCode){

	global $site_list;
	$gs_ag_info = explode("#", $site_list[75]['conf_content']);

	$data = array(
		"method"=>"GetGameUrl",
		"agentCode"=>$gs_ag_info[1],
		"token"=>$gs_ag_info[2],
		"userCode"=>$user_id,
		"nickName"=>$user_id,
		"vendorCode"=>$vendorCode,
		"language"=>"ko"
	);

	$ch=curl_init();
	curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $gs_ag_info[0]);
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_HEADER, false);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Content-Type: application/json'
	));
	curl_setopt($ch, CURLOPT_VERBOSE, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	$response = curl_exec($ch);
	curl_close($ch);

	//echo json_encode($data);

	return $response;
	//{"launchUrl":"https://skylinekgn3.evo-games923.com/entry?jsessionid=d0e45b3b98adacae907f861e&lang=en","status":0,"msg":"Success","description":null}
}

//게임사 리스트
function gdc2_ThirdPartyList(){

	global $site_list;
	$gs_ag_info = explode("#", $site_list[75]['conf_content']);

	$data = array(
		"method"=>"GetVendors",
		"agentCode"=>$gs_ag_info[1],
		"token"=>$gs_ag_info[2]
	);

	

	$ch=curl_init();
	curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $gs_ag_info[0]);
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_HEADER, false);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Content-Type: application/json'
	));
	curl_setopt($ch, CURLOPT_VERBOSE, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	$response = curl_exec($ch);
	curl_close($ch);

	return $response;
}

//게임 리스트
function gdc2_gameList($prd_id){

	global $site_list;
	$gs_ag_info = explode("#", $site_list[75]['conf_content']);

	$data = array(
		"method"=>"GetVendorGames",
		"agentCode"=>$gs_ag_info[1],
		"token"=>$gs_ag_info[2],
		"vendorCode"=>$prd_id
	);

	$ch=curl_init();
	curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $gs_ag_info[0]);
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
	curl_setopt($ch, CURLOPT_HEADER, false);
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		'Content-Type: application/json'
	));
	curl_setopt($ch, CURLOPT_VERBOSE, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
	$response = curl_exec($ch);
	curl_close($ch);

	return $response;
}

///////////////////////////////////////////////////////////////////////////////
?>